/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.convert;

import com.cognos.indications.ILogIndication;
import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.indications.LogValueTraceIndication;
import com.cognos.indications.convert.LogConvertUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTypedLoggerNewImpl
extends LogTypedLogger {
    private Logger theLogger = null;
    protected Class<?> baseMessageType = ILogIndication.class;

    public LogTypedLoggerNewImpl(String name, Class<?> base) {
        this.theLogger = LoggerFactory.getLogger((String)name);
    }

    public LogTypedLoggerNewImpl(String name) {
        this.theLogger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public Level getLevel() {
        return LogConvertUtils.getLevel(this.theLogger);
    }

    @Override
    public String getName() {
        return this.theLogger.getName();
    }

    @Override
    public boolean isEnabled(int detail) {
        return LogConvertUtils.isEnabled(detail, this.theLogger);
    }

    @Override
    public boolean isEnabled(Object o) {
        if (this.baseMessageType.isInstance(o)) {
            int ilevel = ((ILogIndication)o).getLevel();
            return this.isEnabled(ilevel);
        }
        return false;
    }

    @Override
    public boolean isEnabledFor(Level level) {
        return this.isEnabled(level.toInt());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.theLogger.isTraceEnabled();
    }

    @Override
    public void log(Object p0) {
        if (this.baseMessageType.isInstance(p0)) {
            ILogIndication ind = (ILogIndication)p0;
            if (ind.isTimeStampedControlledByIPF()) {
                ind.setTime();
            } else {
                ind.setTimeStampedControlledByIPF(true);
            }
            ind.setLoggerName(this.theLogger.getName());
            LogConvertUtils.log(ind.getLevel(), ind, this.theLogger);
        }
    }

    @Override
    public void logTrace(ILogTraceIndication ind, Throwable throwable) {
        if (this.baseMessageType.isInstance(ind)) {
            if (ind.isTimeStampedControlledByIPF()) {
                ind.setTime();
            } else {
                ind.setTimeStampedControlledByIPF(true);
            }
            ind.setLoggerName(this.theLogger.getName());
            LogConvertUtils.log(ind.getLevel(), ind, throwable, this.theLogger);
        }
    }

    @Override
    public void setLevel(Level level) {
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.theLogger.trace(LogTypedLoggerNewImpl.extractMessage(message), t);
    }

    @Override
    public void trace(Object message) {
        this.theLogger.trace(LogTypedLoggerNewImpl.extractMessage(message));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.theLogger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.theLogger.isInfoEnabled();
    }

    @Override
    public void debug(String msg) {
        this.theLogger.debug(msg);
    }

    @Override
    public void error(String msg) {
        this.theLogger.error(msg);
    }

    @Override
    public void info(String msg) {
        this.theLogger.info(msg);
    }

    @Override
    public void error(String msg, Throwable e) {
        this.theLogger.error(msg, e);
    }

    @Override
    public void addAppender(Appender appender) {
    }

    @Override
    public void log(Level level, String msg) {
        LogConvertUtils.log(level.toInt(), msg, this.theLogger);
    }

    @Override
    public void log(Level level, Object message) {
        LogConvertUtils.log(level.toInt(), message.toString(), this.theLogger);
    }

    @Override
    public void log(Level level, Object message, Throwable t) {
        LogConvertUtils.log(level.toInt(), message.toString(), t, this.theLogger);
    }

    @Override
    public void debug(Object message) {
        this.theLogger.debug(LogTypedLoggerNewImpl.extractMessage(message));
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.theLogger.debug(LogTypedLoggerNewImpl.extractMessage(message), t);
    }

    @Override
    public void error(Object message) {
        this.theLogger.error(LogTypedLoggerNewImpl.extractMessage(message));
    }

    @Override
    public void error(Object message, Throwable t) {
        this.theLogger.error(LogTypedLoggerNewImpl.extractMessage(message), t);
    }

    @Override
    public void info(Object message) {
        this.theLogger.info(LogTypedLoggerNewImpl.extractMessage(message));
    }

    @Override
    public void info(Object message, Throwable t) {
        this.theLogger.info(LogTypedLoggerNewImpl.extractMessage(message), t);
    }

    @Override
    public void warn(Object message) {
        this.theLogger.warn(LogTypedLoggerNewImpl.extractMessage(message));
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.theLogger.warn(message.toString(), t);
    }

    @Override
    public void fatal(Throwable t) {
        this.theLogger.error("", t);
    }

    public static String extractMessage(Object message) {
        String result = null;
        if (message.getClass() == LogAuditIndication.class) {
            LogAuditIndication ind = (LogAuditIndication)message;
            result = ind.getOperation() + '\t' + ind.getLogData();
        } else if (message.getClass() == LogAuditAccessIndication.class) {
            LogAuditAccessIndication ind = (LogAuditAccessIndication)message;
            result = ind.getOperation() + '\t' + ind.getLogData() + '\t' + ind.getStatus() + '\t' + ind.getObjectType() + '\t' + ind.getObjectPath() + '\t' + ind.getErrorMessage();
        } else if (message.getClass() == LogPerfIndication.class) {
            LogPerfIndication ind = (LogPerfIndication)message;
            result = ind.getLogData() + '\t' + ind.getStatus();
        } else if (message.getClass() == LogTraceIndication.class) {
            LogTraceIndication ind = (LogTraceIndication)message;
            result = ind.getMessage() + '\t' + ind.getActionString();
        } else if (message.getClass() == LogValueTraceIndication.class) {
            LogValueTraceIndication ind = (LogValueTraceIndication)message;
            result = ind.getName() + '\t' + ind.getValue();
        }
        return result;
    }
}

