/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.CCLStartupConfiguration;
import com.cognos.cclcfgapi.CFG;
import com.cognos.cclcfgapi.base64;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

public class CCLConfiguration {
    public static final int CCLCFGAPI_Success = 0;
    public static final int CCLCFGAPI_StartupFileNotFound = 1;
    public static final int CCLCFGAPI_StartupFileEmpty = 2;
    public static final int CCLCFGAPI_StartupFileParseError = 3;
    public static final int CCLCFGAPI_StartupFileViolation = 4;
    public static final int CCLCFGAPI_RuntimeDocParseError = 5;
    public static final int CCLCFGAPI_InitAPIWarning = 6;
    public static final int CCLCFGAPI_InitCryptoError = 7;
    public static final int CCLCFGAPI_CryptoDecryptionError = 8;
    public static final int CCLCFGAPI_UnknownException = 9;
    public static final int CCLCFGAPI_InvalidArguments = 10;
    private Document m_configDoc = null;
    private boolean m_bStartupInitialized = false;
    private CAMFactory m_cf = null;
    private EncryptingSession m_es = null;
    protected Map m_parameterNameValueMap = new HashMap();

    public synchronized int init() {
        return this.init((InputStream)null);
    }

    public synchronized int init(InputStream configurationDoc) {
        int result;
        if (null != configurationDoc) {
            SAXReader reader = new SAXReader();
            try {
                Document doc = reader.read(configurationDoc);
                result = this.init(doc.getRootElement());
            }
            catch (DocumentException e) {
                result = 5;
            }
        } else {
            result = this.init((Element)null);
        }
        return result;
    }

    public synchronized int init(Element configurationElement) {
        Element root;
        int result = 0;
        boolean bResolvePaths = false;
        if (null == this.m_configDoc) {
            String name;
            this.m_parameterNameValueMap.clear();
            this.m_configDoc = DocumentHelper.createDocument();
            root = DocumentHelper.createElement((QName)CCLStartupConfiguration.qnParameters);
            this.m_configDoc.add(root);
            root.addAttribute("version", "1.0");
            root.add(CCLStartupConfiguration.nsCFG);
            root.add(CCLStartupConfiguration.nsXSD);
            root.add(CCLStartupConfiguration.nsXSI);
            int index = 0;
            while ((name = CFG.runtimeDefaults[index++]) != null) {
                String factoryDefault = CFG.runtimeDefaults[index++];
                Element param = root.addElement(CCLStartupConfiguration.qnParameter);
                param.addAttribute("name", name);
                Element value = param.addElement(CCLStartupConfiguration.qnValue);
                value.setText(factoryDefault);
                this.m_parameterNameValueMap.put(name, param);
            }
            bResolvePaths = true;
        }
        root = this.m_configDoc.getRootElement();
        if (!this.m_bStartupInitialized) {
            block19: {
                StringBuffer sDoc = new StringBuffer();
                result = CCLStartupConfiguration.getStartupConfigurationDocument(sDoc);
                if (result == 0) {
                    try {
                        Document doc = DocumentHelper.parseText((String)sDoc.toString());
                        Element rootElement = doc.getRootElement();
                        if (rootElement.getQName().equals((Object)CCLStartupConfiguration.qnParameters)) {
                            List comments = rootElement.selectNodes("//comment()");
                            if (comments != null) {
                                for (Comment comment : comments) {
                                    comment.getParent().remove(comment);
                                }
                            }
                            List parameterNodeList = rootElement.elements(CCLStartupConfiguration.qnParameter);
                            for (Element paramElement : parameterNodeList) {
                                Element existElement;
                                String name = paramElement.attributeValue("name");
                                String opaque = paramElement.attributeValue("opaque");
                                Element valueElement = paramElement.element(CCLStartupConfiguration.qnValue);
                                if (null != opaque && 0 == opaque.compareToIgnoreCase("true")) {
                                    valueElement.add(CCLStartupConfiguration.nsCFG);
                                    valueElement.add(CCLStartupConfiguration.nsXSD);
                                    valueElement.add(CCLStartupConfiguration.nsXSI);
                                }
                                if (null != (existElement = (Element)this.m_parameterNameValueMap.get(name))) {
                                    existElement.getParent().remove(existElement);
                                }
                                paramElement.detach();
                                root.add(paramElement);
                                this.m_parameterNameValueMap.put(name, paramElement);
                            }
                            result = 0;
                            bResolvePaths = true;
                            break block19;
                        }
                        result = 4;
                    }
                    catch (DocumentException e) {
                        result = 3;
                    }
                } else {
                    String name;
                    int index = 0;
                    while ((name = CFG.startupDefaults[index++]) != null) {
                        String factoryDefault = CFG.startupDefaults[index++];
                        Element param = root.addElement(CCLStartupConfiguration.qnParameter);
                        param.addAttribute("name", name);
                        Element value = param.addElement(CCLStartupConfiguration.qnValue);
                        value.setText(factoryDefault);
                        this.m_parameterNameValueMap.put(name, param);
                    }
                    result = 0;
                    bResolvePaths = true;
                }
            }
            this.m_bStartupInitialized = true;
        }
        if (null != configurationElement) {
            if (configurationElement.getName().compareTo("queryResult") == 0) {
                this._scanParametersHelper(configurationElement, root);
            } else {
                List resultList = CCLConfiguration.getElementsByTagName(configurationElement, "queryResult");
                for (int i = 0; i < resultList.size(); ++i) {
                    Element resultNode = (Element)resultList.get(i);
                    this._scanParametersHelper(resultNode, root);
                }
            }
            bResolvePaths = true;
        }
        if (bResolvePaths && 0 == result) {
            CCLConfiguration.fixupPaths(root);
        }
        return result;
    }

    private void _scanParametersHelper(Element node, Element root) {
        List itemList = node.elements();
        for (int j = 0; j < itemList.size(); ++j) {
            Element itemElement = (Element)itemList.get(j);
            List paramList = itemElement.elements();
            for (int k = 0; k < paramList.size(); ++k) {
                Element paramElement = (Element)paramList.get(k);
                Element valueElement = paramElement.element("value");
                if (null == valueElement) continue;
                String name = paramElement.getQualifiedName();
                Element existElement = (Element)this.m_parameterNameValueMap.get(name);
                if (null != existElement) {
                    existElement.getParent().remove(existElement);
                }
                Element param = root.addElement(CCLStartupConfiguration.qnParameter);
                param.addAttribute("name", name);
                Element newValueElement = param.addElement(CCLStartupConfiguration.qnValue);
                newValueElement.addAttribute(CCLStartupConfiguration.qnXSIType, valueElement.attributeValue(CCLStartupConfiguration.qnXSIType));
                String encrypted = valueElement.attributeValue("encrypted");
                if (encrypted != null && encrypted.compareToIgnoreCase("true") == 0) {
                    newValueElement.addAttribute("encrypted", encrypted);
                }
                if (valueElement.isTextOnly()) {
                    newValueElement.setText(valueElement.getText());
                } else {
                    newValueElement.add((Element)valueElement.clone());
                }
                this.m_parameterNameValueMap.put(name, param);
            }
        }
    }

    public synchronized int getValue(String paramName, boolean decrypt, StringBuffer valueBuffer) {
        if (null == paramName || null == valueBuffer) {
            return 10;
        }
        valueBuffer.setLength(0);
        if (paramName.length() > 0) {
            Element paramElement = (Element)this.m_parameterNameValueMap.get(paramName);
            if (null != paramElement) {
                String value;
                String opaque = paramElement.attributeValue("opaque");
                Element valueElement = paramElement.element(CCLStartupConfiguration.qnValue);
                if (null != opaque && 0 == opaque.compareToIgnoreCase("true") || !valueElement.isTextOnly()) {
                    if (decrypt) {
                        EncryptingSession es = this.getCrypto();
                        if (null == es) {
                            return 7;
                        }
                        if (null == (valueElement = CCLConfiguration.decryptXML((Element)valueElement.clone(), es))) {
                            return 8;
                        }
                    }
                    value = valueElement.asXML();
                } else {
                    String encrypted = valueElement.attributeValue("encrypted");
                    value = valueElement.getText();
                    if (decrypt && null != encrypted && 0 == encrypted.compareToIgnoreCase("true")) {
                        EncryptingSession es = this.getCrypto();
                        if (null == es) {
                            return 7;
                        }
                        if (null == (value = CCLConfiguration.decryptString(value, es))) {
                            return 8;
                        }
                    }
                }
                valueBuffer.append(value);
            }
        } else {
            Element rootElement = this.m_configDoc.getRootElement();
            if (decrypt) {
                EncryptingSession es = this.getCrypto();
                if (null == es) {
                    return 7;
                }
                if (null == (rootElement = CCLConfiguration.decryptXML((Element)rootElement.clone(), es))) {
                    return 8;
                }
            }
            valueBuffer.append(rootElement.asXML());
        }
        return 0;
    }

    public synchronized int getValue(String paramName, boolean decrypt, List valueNode) {
        if (null == paramName || null == valueNode) {
            return 10;
        }
        Element element = null;
        if (paramName.length() > 0) {
            Object found = this.m_parameterNameValueMap.get(paramName);
            if (null != found) {
                Element valueElement = ((Element)found).element(CCLStartupConfiguration.qnValue);
                element = (Element)valueElement.clone();
            }
        } else {
            element = (Element)this.m_configDoc.getRootElement().clone();
        }
        if (null != element) {
            if (decrypt) {
                EncryptingSession es = this.getCrypto();
                if (null == es) {
                    return 7;
                }
                if (null == (element = CCLConfiguration.decryptXML(element, es))) {
                    return 8;
                }
            }
            valueNode.add(element);
        }
        return 0;
    }

    static void fixupPaths(Element element) {
        List valueList = CCLConfiguration.getElementsByTagNameNS(element, "crn", "http://developer.cognos.com/schemas/crconfig/1/", "value");
        for (int k = 0; k < valueList.size(); ++k) {
            String pathValue;
            Element valueElement = (Element)valueList.get(k);
            String sType = valueElement.attributeValue(CCLStartupConfiguration.qnXSIType);
            if (sType == null || sType.compareTo("cfg:folderPath") != 0 && sType.compareTo("cfg:filePath") != 0 || (pathValue = valueElement.getText()).length() <= 0) continue;
            valueElement.setText(CCLConfigurationUtils.resolveEffectivePath(pathValue));
        }
    }

    private static List getElementsByTagNameNS(Element element, String sPrefix, String sNamespace, String sLocalName) {
        ArrayList list = new ArrayList();
        Namespace namespace = new Namespace(sPrefix, sNamespace);
        QName qName = new QName(sLocalName, namespace);
        CCLConfiguration.getElementsByTagNameNSHelper(list, element, qName);
        return list;
    }

    private static void getElementsByTagNameNSHelper(List list, Element element, QName qName) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            if (elem.getQName().equals((Object)qName)) {
                list.add(elem);
            }
            CCLConfiguration.getElementsByTagNameNSHelper(list, elem, qName);
        }
    }

    private static List getElementsByTagName(Element element, String sLocalName) {
        ArrayList list = new ArrayList();
        CCLConfiguration.getElementsByTagNameHelper(list, element, sLocalName);
        return list;
    }

    private static void getElementsByTagNameHelper(List list, Element element, String sLocalName) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            if (elem.getName().equals(sLocalName)) {
                list.add(elem);
            }
            CCLConfiguration.getElementsByTagNameHelper(list, elem, sLocalName);
        }
    }

    public String resolveEffectivePath(String path) {
        return CCLConfigurationUtils.convertToAbsolutePath(path);
    }

    private synchronized EncryptingSession getCrypto() {
        if (null == this.m_cf) {
            this.m_cf = new CAMFactory();
            try {
                this.m_cf.initialize("<initializeDocument><serviceID>CFGAPI</serviceID></initializeDocument>".getBytes());
                this.m_es = this.m_cf.createEncryptingSession();
            }
            catch (CAMCryptoException cAMCryptoException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_es;
    }

    private static String decryptString(String encryptedBuffer, EncryptingSession es) {
        if (encryptedBuffer.length() > 0) {
            byte[] decodedBuffer = null;
            try {
                decodedBuffer = base64.decode(0, encryptedBuffer);
                byte[] sDecryptedValue = es.decryptData(decodedBuffer);
                return new String(sDecryptedValue, "UTF-8");
            }
            catch (CAMCryptoException e) {}
            finally {
                return null;
            }
        }
        return encryptedBuffer;
    }

    private static Element decryptXML(Element encryptedElement, EncryptingSession es) {
        if (CCLConfiguration.decryptLeafElement(encryptedElement, es)) {
            return encryptedElement;
        }
        return CCLConfiguration.decryptXMLHelper(encryptedElement, es);
    }

    private static Element decryptXMLHelper(Element encryptedElement, EncryptingSession es) {
        Iterator it = encryptedElement.elementIterator();
        while (it.hasNext()) {
            Element element;
            Node node = (Node)it.next();
            if (node.getNodeType() != 1 || CCLConfiguration.decryptLeafElement(element = (Element)node, es)) continue;
            CCLConfiguration.decryptXMLHelper(element, es);
        }
        return encryptedElement;
    }

    private static boolean decryptLeafElement(Element element, EncryptingSession es) {
        Attribute encryptedAttr = element.attribute("encrypted");
        String type = element.attributeValue(CCLStartupConfiguration.qnXSIType);
        if (encryptedAttr != null && encryptedAttr.getText().compareToIgnoreCase("true") == 0 && type.compareTo("cfg:systemPassword") != 0 && element.isTextOnly() && element.nodeCount() > 0) {
            Text textNode;
            StringBuffer sText = new StringBuffer();
            ArrayList<Text> listOfTextNodes = new ArrayList<Text>();
            for (int i = 0; i < element.nodeCount(); ++i) {
                Node node2 = element.node(i);
                if (node2.getNodeType() != 3) continue;
                textNode = (Text)node2;
                listOfTextNodes.add(textNode);
                sText.append(textNode.getText());
            }
            String decryptedValue = CCLConfiguration.decryptString(sText.toString(), es);
            if (null != decryptedValue) {
                encryptedAttr.getParent().remove(encryptedAttr);
                for (int j = 0; j < listOfTextNodes.size(); ++j) {
                    textNode = (Text)listOfTextNodes.get(j);
                    element.remove(textNode);
                }
                try {
                    Document docFragment = DocumentHelper.parseText((String)decryptedValue);
                    Element fragElement = docFragment.getRootElement();
                    fragElement.detach();
                    element.add(fragElement);
                }
                catch (DocumentException e) {
                    element.setText(decryptedValue);
                }
                return true;
            }
        }
        return false;
    }
}

