/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.admin.core.utils.FieldsQueryParam;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class QueryParams {
    private HttpServletRequest servletRequest;

    public QueryParams(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        String value = this.servletRequest.getParameter(name);
        return value != null ? Boolean.valueOf(value) : Boolean.valueOf(defaultValue);
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        String value = this.servletRequest.getParameter(name);
        return value == null ? defaultValue : value;
    }

    public Long getLong(String name, Long defaultValue) {
        String value = this.servletRequest.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new HttpException(400, new Message(MessageKeys.INVALID_FIELD_VALUE, (Object)name));
        }
    }

    public String[] getStringArray(String name) {
        return this.getStringArray(name, null);
    }

    public String[] getStringArray(String name, String defaultValue) {
        String[] params = this.servletRequest.getParameterValues(name);
        if (params == null) {
            if (defaultValue == null) {
                return null;
            }
            params = new String[]{defaultValue};
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            for (String s : param.split(",")) {
                result.add(s);
            }
        }
        return result.toArray(new String[0]);
    }

    public FieldsQueryParam getFields(String defaultValue) {
        return this.getFields(defaultValue, true);
    }

    public FieldsQueryParam getFields(String defaultValue, boolean addImplicitDefaults) {
        String[] params = this.servletRequest.getParameterValues("fields");
        if (params != null) {
            StringBuilder buf = new StringBuilder();
            for (String param : params) {
                buf.append(param).append(',');
            }
            defaultValue = buf.toString();
        }
        return new FieldsQueryParam(defaultValue, null, addImplicitDefaults);
    }
}

