/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SimpleXmlToJsonParser {
    private XMLStreamReader reader;
    private StringBuilder buf = new StringBuilder(128);

    private SimpleXmlToJsonParser(String value) throws XMLStreamException {
        this.reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(new StringReader(value));
        this.buf = new StringBuilder(128);
    }

    public static JsonObject parse(String value) throws XMLStreamException {
        return new SimpleXmlToJsonParser(value).parseDocument();
    }

    private JsonObject parseDocument() throws XMLStreamException {
        JsonObject result = new JsonObject();
        while (true) {
            switch (this.reader.next()) {
                case 1: {
                    String tag = this.reader.getLocalName();
                    result.put(tag, this.parseElement());
                    return result;
                }
            }
        }
    }

    private Object parseElement() throws XMLStreamException {
        this.buf.setLength(0);
        JsonObject result = null;
        while (true) {
            switch (this.reader.next()) {
                case 1: {
                    result = this.handleStartElement(result);
                    break;
                }
                case 4: 
                case 12: {
                    if (result != null) break;
                    this.buf.append(this.reader.getText());
                    break;
                }
                case 2: {
                    return result != null ? result : this.buf.toString().trim();
                }
            }
        }
    }

    private JsonObject handleStartElement(JsonObject result) throws XMLStreamException {
        Object old;
        String tag = this.reader.getLocalName();
        Object o = this.parseElement();
        if (result == null) {
            result = new JsonObject();
        }
        if ((old = result.get(tag)) == null) {
            result.put(tag, o);
        } else {
            if (!(old instanceof JsonArray)) {
                JsonArray array = new JsonArray();
                array.add(old);
                result.put(tag, (Object)array);
                old = array;
            }
            ((JsonArray)old).add(o);
        }
        return result;
    }
}

