/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.SoapContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responder {
    private static final Logger logger = LoggerFactory.getLogger(Responder.class);
    protected SoapContext soapContext;
    private Request request;

    public Responder(SoapContext soapContext, Request request) {
        this.soapContext = soapContext;
        this.request = request;
    }

    public Response cmQueryResponse(JsonObject data, boolean allowNotFound) {
        return this.queryResponse(data, allowNotFound).build();
    }

    protected Response.ResponseBuilder queryResponse(JsonObject data, boolean allowNotFound) {
        Response.ResponseBuilder builder = null;
        String cacheValidator = data.getString("cacheValidator");
        if ("GONE".equals(cacheValidator)) {
            builder = Response.status((Response.Status)Response.Status.GONE);
            cacheValidator = null;
        } else if ("NOT_SUPPORTED".equals(cacheValidator)) {
            cacheValidator = null;
        }
        EntityTag etag = null;
        boolean privateCC = true;
        if (cacheValidator != null) {
            etag = new EntityTag(cacheValidator);
            privateCC = !this.isPublicEtag(cacheValidator);
            builder = this.request.evaluatePreconditions(etag);
        }
        if (builder == null) {
            JsonArray objects = data.getArray("objects");
            JsonObject result = new JsonObject();
            result.put("data", (Object)objects);
            builder = objects.isEmpty() && allowNotFound ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok();
            builder.entity((Object)result).cacheControl(this.createCC(privateCC));
        }
        if (etag != null) {
            builder = builder.tag(etag);
        }
        return this.soapContext.saveState(builder);
    }

    protected CacheControl createCC(boolean isPrivate) {
        CacheControl cc = new CacheControl();
        cc.setPrivate(isPrivate);
        cc.setMustRevalidate(true);
        cc.setNoTransform(false);
        return cc;
    }

    private boolean isPublicEtag(String cacheValidator) {
        return cacheValidator.startsWith("41-");
    }

    public Response cmAddResponse(JsonObject data) {
        String uri = "";
        try {
            uri = (String)data.getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (NullPointerException npe) {
            logger.error("Unable to locate _meta.links.self.url property");
        }
        return this.soapContext.saveState(Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)uri)).build();
    }

    public Response cmAddResponse(JsonArray data) {
        String uri = "";
        try {
            uri = (String)data.getObject(0).getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (NullPointerException npe) {
            logger.error("Unable to locate _meta.links.self.url proeprty");
        }
        return this.soapContext.saveState(Response.status((Response.Status)Response.Status.CREATED).entity(data.get(0)).header("Location", (Object)uri)).build();
    }

    public Response cmDeleteResponse(Long count) {
        JsonObject result = new JsonObject();
        result.put("count", (Object)count);
        return this.soapContext.saveState(Response.ok((Object)result)).build();
    }

    public Response cmUpdateResponse(JsonArray data) {
        return this.noContent();
    }

    public Response cmUpdateResponse(JsonObject data) {
        return this.noContent();
    }

    public Response noContent() {
        return this.soapContext.saveState(Response.noContent()).build();
    }
}

