/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.restful.PathParser;
import java.util.HashMap;
import java.util.Map;

public class MetaHelper {
    private static final String PROP_META = "_meta";
    private static final String PROP_MIMETYPE = "mimeType";
    private static final String PROP_URL = "url";
    private static final String PROP_LINKS = "links";
    private static final String PROP_PATH = "path";
    private static final String OBJECTS = "objects";
    private static final String NAMESPACES = "namespaces";
    private static final String ROLES = "roles";
    private static final String GROUPS = "groups";
    private static final String CAPABILITIES = "capabilities";
    private static final String PATH = "path";
    private static final String SELF = "self";
    private static final String MIMETYPE_PREFIX = "application/vnd.ibm.bi.";
    private static final String MIMETYPE_SUFFIX = "+json";
    private static final String MIMETYPE_JSON = "application/json";
    private static final HashMap<String, Link[]> typeLinks = new HashMap();
    private Object jsMeta;
    private JsonFactory json;

    public MetaHelper(JsonFactory json) {
        this.json = json;
        this.jsMeta = json.createString(PROP_META);
    }

    public Map getMeta(Map object, boolean create) {
        Map result = (Map)object.get(this.jsMeta);
        if (result == null && create) {
            result = this.json.createObject();
            object.put(this.jsMeta, result);
        }
        return result;
    }

    public void createLinks(Map obj, String type, Object id, String baseURL, Object searchPath) {
        String strId = this.json.toString(id);
        Map jLinks = this.json.createObject();
        Link[] links = typeLinks.get(type);
        String prefix = null;
        boolean hasSelf = false;
        StringBuilder buf = new StringBuilder();
        buf.append(baseURL);
        int baseLen = baseURL.length();
        if (links != null) {
            for (Link link : links) {
                if (link.prefix != prefix) {
                    prefix = link.prefix;
                    buf.setLength(baseURL.length());
                    buf.append(prefix).append('/').append(strId);
                    baseLen = buf.length();
                } else {
                    buf.setLength(baseLen);
                }
                if (link.suffix != null) {
                    buf.append('/').append(link.suffix);
                }
                String mimeType = MIMETYPE_JSON;
                if (link.name == SELF) {
                    hasSelf = true;
                    mimeType = this.getMimeType(type);
                }
                jLinks.put(this.json.createString(link.name), this.createLink(this.json, buf.toString(), mimeType));
            }
        }
        if (!hasSelf) {
            if (prefix != OBJECTS) {
                buf.setLength(baseURL.length());
                buf.append(OBJECTS).append('/').append(strId);
            } else {
                buf.setLength(baseLen);
            }
            jLinks.put(this.json.createString(SELF), this.createLink(this.json, buf.toString(), this.getMimeType(type)));
            if (searchPath != null) {
                StringBuilder sb = new StringBuilder(baseURL);
                sb.append("path").append("?path=");
                sb.append(PathParser.parseSearchPathIntoPath(this.json.toString(searchPath)));
                jLinks.put(this.json.createString("path"), this.createLink(this.json, sb.toString(), this.getMimeType(type)));
            }
        }
        Map _meta = this.getMeta(obj, true);
        _meta.put(this.json.createString(PROP_LINKS), jLinks);
    }

    private String getMimeType(String type) {
        return MIMETYPE_PREFIX + type + MIMETYPE_SUFFIX;
    }

    private Map createLink(JsonFactory json, String url, String mimetype) {
        Map result = json.createObject();
        result.put(json.createString(PROP_URL), json.createString(url));
        result.put(json.createString(PROP_MIMETYPE), json.createString(mimetype));
        return result;
    }

    static {
        Link[] items = Link.makeLinks("items");
        Link[] reportLinks = Link.makeLinks("histories", "versions");
        Link[] histories = Link.makeLinks("histories");
        Link[] smarts_modules = Link.makeLinks("smarts_modules");
        Link[] modelingLinks = Link.makeLinks("base_module", "smarts_modules");
        typeLinks.put("namespace", new Link[]{new Link("items", NAMESPACES, "items"), new Link(SELF, OBJECTS, null)});
        typeLinks.put("namespaceFolder", new Link[]{new Link("items", NAMESPACES, "items"), new Link(SELF, OBJECTS, null)});
        typeLinks.put("account", new Link[]{new Link("items", OBJECTS, "items"), new Link(SELF, OBJECTS, null)});
        typeLinks.put("role", new Link[]{new Link("members", ROLES, "members"), new Link(SELF, OBJECTS, null)});
        typeLinks.put("group", new Link[]{new Link("members", GROUPS, "members"), new Link(SELF, OBJECTS, null)});
        typeLinks.put("content", items);
        typeLinks.put("folder", items);
        typeLinks.put("adminFolder", items);
        typeLinks.put("dataSetFolder", items);
        typeLinks.put("package", Link.makeLinks("items", "models", "configuration", "drill_paths", "base_module", "smarts_modules"));
        typeLinks.put("report", reportLinks);
        typeLinks.put("query", reportLinks);
        typeLinks.put("analysis", reportLinks);
        typeLinks.put("reportView", reportLinks);
        typeLinks.put("interactiveReport", reportLinks);
        typeLinks.put("powerPlayReport", reportLinks);
        typeLinks.put("powerPlay8Report", reportLinks);
        typeLinks.put("powerPlay8ReportView", reportLinks);
        typeLinks.put("agentDefinition", reportLinks);
        typeLinks.put("agentDefinitionView", reportLinks);
        typeLinks.put("jobDefinition", reportLinks);
        typeLinks.put("reportVersion", Link.makeLinks("outputs"));
        typeLinks.put("importDeployment", histories);
        typeLinks.put("exportDeployment", histories);
        typeLinks.put("contentTask", histories);
        typeLinks.put("history", new Link[]{new Link("details", OBJECTS, "history_details")});
        typeLinks.put("securedFunction", new Link[]{new Link(SELF, CAPABILITIES, null)});
        typeLinks.put("securedFeature", new Link[]{new Link(SELF, CAPABILITIES, null)});
        typeLinks.put("productCapability", new Link[]{new Link(SELF, CAPABILITIES, null)});
        typeLinks.put("uploadedFile", modelingLinks);
        typeLinks.put("dataSourceConnection", modelingLinks);
        typeLinks.put("dataSourceSchema", modelingLinks);
        typeLinks.put("dataSet2", modelingLinks);
        typeLinks.put("module", smarts_modules);
    }

    private static class Link {
        public String name;
        public String prefix;
        public String suffix;

        public Link(String name) {
            this(name, MetaHelper.OBJECTS, name);
        }

        public Link(String name, String prefix, String suffix) {
            this.name = name;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public static Link[] makeLinks(String ... names) {
            Link[] result = new Link[names.length];
            int i = 0;
            for (String name : names) {
                result[i++] = new Link(name);
            }
            return result;
        }
    }
}

