/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.SOAPWriter;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.StructType;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructHandler
implements TypeHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StructHandler.class);
    public static final char SPECIAL_PROPERTY_PREFIX = '_';

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        if (dc.isXsiNil()) {
            XmlStreamUtils.skipElement(dc.reader);
            return dc.json.createNull();
        }
        StructType structType = (StructType)type;
        Map result = dc.json.createObject();
        dc.stack.add(result);
        while (dc.nextTag() != 2) {
            String name = dc.reader.getLocalName();
            Property prop = structType.getProperty(name);
            if (prop == null) {
                StructHandler.logUnknownProperty(structType.getName(), name);
                XmlStreamUtils.skipElement(dc.reader);
                continue;
            }
            this.putProperty(dc, prop, result);
        }
        dc.stack.remove(dc.stack.size() - 1);
        return result;
    }

    protected void putProperty(DeserializationContext dc, Property prop, Map result) throws XMLStreamException {
        try {
            Object value = prop.deserialize(dc);
            result.put(dc.json.createString(prop.getName()), value);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        ((SOAPWriter)sc.writer.element(tag)).type(type);
        if (sc.json.isNull(value)) {
            sc.writer.xsiNil();
        } else {
            Map props = (Map)value;
            StructType structType = (StructType)type;
            sc.stack.add(value);
            if (sc.orderedProperties) {
                int size = structType.properties().size();
                Property[] propArray = new Property[size];
                Object[] valueArray = new Object[size];
                for (Map.Entry entry : props.entrySet()) {
                    String propName = sc.json.toString(entry.getKey());
                    if (propName.charAt(0) == '_') continue;
                    Property prop = structType.getProperty(propName);
                    if (prop == null) {
                        StructHandler.logUnknownProperty(structType.getName(), propName);
                        continue;
                    }
                    propArray[prop.getOrder()] = prop;
                    valueArray[prop.getOrder()] = entry.getValue();
                }
                for (int i = 0; i < size; ++i) {
                    if (propArray[i] == null) continue;
                    propArray[i].serialize(sc, valueArray[i]);
                }
            } else {
                for (Map.Entry entry : props.entrySet()) {
                    String propName = sc.json.toString(entry.getKey());
                    if (propName.charAt(0) == '_') continue;
                    Property prop = structType.getProperty(propName);
                    if (prop != null) {
                        prop.serialize(sc, entry.getValue());
                        continue;
                    }
                    StructHandler.logUnknownProperty(structType.getName(), propName);
                }
            }
            sc.stack.remove(sc.stack.size() - 1);
        }
        sc.writer.end();
    }

    protected static void logUnknownProperty(String type, String property) {
        LOGGER.warn("Type '" + type + "' doesn't have property '" + property + "'");
    }
}

