/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XMLUtils;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class ContentManager
extends SoapService
implements SoapFaultHandler {
    private int REST_REQUEST_TIMEOUT = 30000;
    public static final String INVALID_CACHE_VALIDATOR = "NOT_SUPPORTED";
    private static Method QUERY;
    private static Method QUERY_MULTIPLE;
    private static Method QUERY_MULTIPLE_CACHE;
    private static Method ADD;
    private static Method DELETE;
    static Method UPDATE;
    private static Method COPY;
    private static Method MOVE;
    private static Method COPYRENAME;
    private static Method COPYACCOUNT;
    private static Method MOVERENAME;
    private static Method TEST_CONNECTION;
    private static Method LIST_ARCHIVES;
    private static Method GET_ACTIVE_CONTENT_MANAGER;
    private static Method GET_DEPLOYMENT_OPTIONS;
    private static Method DELETE_TENANTS;
    private static Method CREATE_ACCOUNT_PROXY;
    private static Method DELETE_ACCOUNT;
    private static Method NOOP;
    static HashMap<String, Integer> mapCmErrorToHttpStatus;

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = ContentManager.class.getResourceAsStream("contentManagerService.xml");){
            methods = serviceLoader.load(typeLib, is);
        }
        QUERY = methods.get("query");
        QUERY_MULTIPLE = methods.get("queryMultiple");
        QUERY_MULTIPLE_CACHE = methods.get("queryMultipleCache");
        ADD = methods.get("add");
        DELETE = methods.get("delete");
        UPDATE = methods.get("update");
        COPY = methods.get("copy");
        MOVE = methods.get("move");
        COPYRENAME = methods.get("copyRename");
        COPYACCOUNT = methods.get("copyAccount");
        MOVERENAME = methods.get("moveRename");
        TEST_CONNECTION = methods.get("testDataSourceConnection");
        LIST_ARCHIVES = methods.get("listArchives");
        GET_ACTIVE_CONTENT_MANAGER = methods.get("getActiveContentManager");
        GET_DEPLOYMENT_OPTIONS = methods.get("getDeploymentOptions");
        DELETE_TENANTS = methods.get("deleteTenants");
        CREATE_ACCOUNT_PROXY = methods.get("createAccountProxy");
        DELETE_ACCOUNT = methods.get("deleteAccount");
        NOOP = methods.get(null);
    }

    public ContentManager(BiBus bus) {
        super(bus);
    }

    public Map queryRequest(String searchPath, List properties, List sortBy, Map options) {
        return this.queryRequest(searchPath, properties, sortBy, options, true);
    }

    public List query(String searchPath, List properties, List sortBy, Map options) throws Exception {
        return this.query(searchPath, properties, sortBy, options, this.REST_REQUEST_TIMEOUT);
    }

    public List query(String searchPath, List properties, List sortBy, Map options, int requestTimeout) throws Exception {
        Map obj = this.queryRequest(searchPath, properties, sortBy, options, false);
        return (List)this.invoke(QUERY, obj, requestTimeout);
    }

    public List queryMultiple(List queryRequests) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("requests"), queryRequests);
        return (List)this.invoke(QUERY_MULTIPLE, obj);
    }

    private Map queryRequest(String searchPath, List properties, List sortBy, Map options, boolean forMultiple) {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString(forMultiple ? "search" : "searchPath"), json.createString(searchPath));
        obj.put(json.createString("properties"), properties);
        if (sortBy != null) {
            obj.put(json.createString("sortBy"), sortBy);
        }
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return obj;
    }

    public Map queryMultipleCache(List queryRequests, String cacheValidator) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("requests"), queryRequests);
        Map options = json.createObject();
        options.put("cacheValidator", cacheValidator);
        obj.put(json.createString("options"), options);
        return (Map)this.invoke(QUERY_MULTIPLE_CACHE, obj);
    }

    public List add(String parentPath, List objects, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("parentPath"), parentPath);
        obj.put(json.createString("objects"), objects);
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return (List)this.invoke(ADD, obj);
    }

    public List copy(List searchPaths, String targetPath, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("objects"), this.convertSearchPathsToObjects(searchPaths));
        obj.put(json.createString("targetPath"), targetPath);
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return (List)this.invoke(COPY, obj);
    }

    public List copyRename(List searchPaths, String targetPath, List newNames, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("objects"), this.convertSearchPathsToObjects(searchPaths));
        obj.put(json.createString("targetPath"), targetPath);
        obj.put(json.createString("newNames"), newNames);
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return (List)this.invoke(COPYRENAME, obj);
    }

    public void copyAccount(String sourceAccountPath, String targetAccountPath, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("sourceAccountPath"), json.createString(sourceAccountPath));
        obj.put(json.createString("targetAccountPath"), json.createString(targetAccountPath));
        if (options != null) {
            List optionsArray = json.createArray();
            if (options.get("folders") != null) {
                Map folder = json.createObject();
                folder.put(json.createString("type"), json.createString("copyAccountOptionBoolean"));
                folder.put(json.createString("name"), json.createString("folders"));
                folder.put(json.createString("value"), options.get("folders"));
                optionsArray.add(folder);
            }
            if (options.get("preferences") != null) {
                Map preferences = json.createObject();
                preferences.put(json.createString("type"), json.createString("copyAccountOptionBoolean"));
                preferences.put(json.createString("name"), json.createString("preferences"));
                preferences.put(json.createString("value"), options.get("preferences"));
                optionsArray.add(preferences);
            }
            if (options.get("pages") != null) {
                Map pages = json.createObject();
                pages.put(json.createString("type"), json.createString("copyAccountOptionBoolean"));
                pages.put(json.createString("name"), json.createString("pages"));
                pages.put(json.createString("value"), options.get("pages"));
                optionsArray.add(pages);
            }
            obj.put(json.createString("options"), optionsArray);
        }
        this.invoke(COPYACCOUNT, obj);
    }

    public List move(List searchPaths, String targetPath, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("objects"), this.convertSearchPathsToObjects(searchPaths));
        obj.put(json.createString("targetPath"), targetPath);
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return (List)this.invoke(MOVE, obj);
    }

    public List moveRename(List searchPaths, String targetPath, List newNames, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("objects"), this.convertSearchPathsToObjects(searchPaths));
        obj.put(json.createString("targetPath"), targetPath);
        obj.put(json.createString("newNames"), newNames);
        if (options != null) {
            obj.put(json.createString("options"), options);
        }
        return (List)this.invoke(MOVERENAME, obj);
    }

    private int httpStatusFromMessage(Object detail, String code) {
        String message = this.getDetailMessage((Map)detail);
        if (message.startsWith("CM-SYS-")) {
            return 500;
        }
        Integer status = code == null ? null : mapCmErrorToHttpStatus.get(code);
        return status != null ? status : 400;
    }

    private String getDetailMessage(Map<?, ?> details) {
        List messages;
        JsonFactory json = this.bus.getJsonFactory();
        if (!json.isNull(details) && !json.isNull((Object)(messages = (List)details.get(json.toString((Object)"messages")))) && messages.size() != 0) {
            return json.toString(messages.get(0));
        }
        return "";
    }

    public void noop() throws Exception {
        this.invoke(NOOP, null);
    }

    public Object delete(List searchPaths, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        List items = this.convertSearchPathsToObjects(searchPaths);
        Map request = json.createObject();
        request.put(json.createString("objects"), items);
        if (options != null) {
            request.put(json.createString("options"), options);
        }
        return this.invoke(DELETE, request);
    }

    private List convertSearchPathsToObjects(List searchPaths) {
        JsonFactory json = this.bus.getJsonFactory();
        List items = json.createArray();
        for (Object item : searchPaths) {
            Map baseObject = json.createObject();
            baseObject.put(json.createString("searchPath"), item);
            baseObject.put(json.createString("type"), json.createString("baseClass"));
            items.add(baseObject);
        }
        return items;
    }

    public Object update(List objects, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("objects"), objects);
        if (options != null) {
            request.put(json.createString("options"), options);
        }
        return this.invoke(UPDATE, request);
    }

    public void testDataSourceConnection(String connectionStr, String credentialStr) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("connectionString"), json.createString(connectionStr));
        request.put(json.createString("credentials"), json.createString(credentialStr));
        this.invoke(TEST_CONNECTION, request);
    }

    public List listArchives() throws Exception {
        return (List)this.invoke(LIST_ARCHIVES, null);
    }

    public String getActiveContentManager() throws Exception {
        return (String)this.invoke(GET_ACTIVE_CONTENT_MANAGER, null);
    }

    public void deleteTenants(List tenantIDs) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("tenantIDs"), tenantIDs);
        this.invoke(DELETE_TENANTS, request);
    }

    public List getDeploymentOptions(String archive, String password) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("archive"), json.createString(archive));
        if (password != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<credential><password>").append(XMLUtils.escapeElementText(password)).append("</password></credential>");
            List options = json.createArray();
            Map pwdOption = json.createObject();
            pwdOption.put(json.createString("name"), json.createString("archiveEncryptPassword"));
            pwdOption.put(json.createString("type"), json.createString("deploymentOptionAnyType"));
            pwdOption.put(json.createString("value"), json.createString(buf.toString()));
            options.add(pwdOption);
            request.put(json.createString("options"), options);
        }
        return (List)this.invoke(GET_DEPLOYMENT_OPTIONS, request);
    }

    public List createAccountProxy(String namespace, List objects) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("namespace"), json.createString(namespace));
        request.put(json.createString("objects"), objects);
        return (List)this.invoke(CREATE_ACCOUNT_PROXY, request);
    }

    public void deleteAccount(String objectPath) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("objectPath"), json.createString(objectPath));
        this.invoke(DELETE_ACCOUNT, request);
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this;
    }

    @Override
    public void parseFault(DeserializationContext dc) throws XMLStreamException, SoapException {
        String busNs = dc.typeLibrary.getSchemaByName("bus").getNamespaceURI();
        while (dc.reader.nextTag() != 2) {
            if (dc.reader.getLocalName().equals("detail")) {
                while (dc.reader.nextTag() != 2) {
                    QName qname = dc.reader.getName();
                    Map detail = dc.json.createObject();
                    String code = null;
                    if (qname.getLocalPart() == "exception" && qname.getNamespaceURI().equals(busNs)) {
                        code = this.parseCmException(dc, detail);
                    } else {
                        XmlStreamUtils.skipElement(dc.reader);
                    }
                    if (code == null) continue;
                    throw new SoapException(this.httpStatusFromMessage(detail, code), code, detail);
                }
                continue;
            }
            XmlStreamUtils.skipElement(dc.reader);
        }
    }

    private String parseCmException(DeserializationContext dc, Map detail) throws XMLStreamException, SoapException {
        String errorCode = null;
        List messages = dc.json.createArray();
        detail.put(dc.json.createString("messages"), messages);
        while (dc.reader.nextTag() != 2) {
            String tag = dc.reader.getLocalName();
            if (tag.equals("severity") || tag.equals("errorCode")) {
                String text = dc.reader.getElementText();
                if (tag.equals("errorCode")) {
                    errorCode = text;
                }
                detail.put(dc.json.createString(tag), dc.json.createString(text));
                continue;
            }
            if (!tag.equals("message")) continue;
            while (dc.reader.nextTag() != 2) {
                tag = dc.reader.getLocalName();
                if (tag.equals("messageString")) {
                    messages.add(dc.json.createString(dc.reader.getElementText()));
                    continue;
                }
                XmlStreamUtils.skipElement(dc.reader);
            }
        }
        return errorCode;
    }

    static {
        mapCmErrorToHttpStatus = new HashMap();
        mapCmErrorToHttpStatus.put("cmNoWrite", 403);
    }
}

