/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.phrasespec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import simplenlg.features.ClauseStatus;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;
import simplenlg.phrasespec.AdvPhraseSpec;
import simplenlg.phrasespec.VPPhraseSpec;

public class SPhraseSpec
extends PhraseElement {
    static final List<String> vpFeatures = Arrays.asList("modal", "tense", "negated", "number", "passive", "perfect", "particle", "person", "progressive", "realise_auxiliary", "form", "interrogative_type");

    public SPhraseSpec(NLGFactory phraseFactory) {
        super(PhraseCategory.CLAUSE);
        this.setFactory(phraseFactory);
        this.setVerbPhrase(phraseFactory.createVerbPhrase());
        this.setFeature("elided", false);
        this.setFeature("clause_status", (Object)ClauseStatus.MATRIX);
        this.setFeature("suppressed_complementiser", false);
        this.setFeature("expletive_subject", false);
        this.setFeature("complementiser", phraseFactory.createWord("that", LexicalCategory.COMPLEMENTISER));
    }

    public void setFeature(String featureName, Object featureValue) {
        NLGElement verbPhrase;
        super.setFeature(featureName, featureValue);
        if (vpFeatures.contains(featureName) && ((verbPhrase = this.getFeatureAsElement("verb_phrase")) != null || verbPhrase instanceof VPPhraseSpec)) {
            verbPhrase.setFeature(featureName, featureValue);
        }
    }

    public void addPreModifier(NLGElement newPreModifier) {
        NLGElement verbPhrase = this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null) {
            if (verbPhrase instanceof PhraseElement) {
                ((PhraseElement)verbPhrase).addPreModifier(newPreModifier);
            } else if (verbPhrase instanceof CoordinatedPhraseElement) {
                ((CoordinatedPhraseElement)verbPhrase).addPreModifier(newPreModifier);
            } else {
                super.addPreModifier(newPreModifier);
            }
        }
    }

    public void addComplement(NLGElement complement) {
        PhraseElement verbPhrase = (PhraseElement)this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null || verbPhrase instanceof VPPhraseSpec) {
            verbPhrase.addComplement(complement);
        } else {
            super.addComplement(complement);
        }
    }

    public void addComplement(String newComplement) {
        PhraseElement verbPhrase = (PhraseElement)this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null || verbPhrase instanceof VPPhraseSpec) {
            verbPhrase.addComplement(newComplement);
        } else {
            super.addComplement(newComplement);
        }
    }

    public void setFeature(String featureName, boolean featureValue) {
        NLGElement verbPhrase;
        super.setFeature(featureName, featureValue);
        if (vpFeatures.contains(featureName) && ((verbPhrase = this.getFeatureAsElement("verb_phrase")) != null || verbPhrase instanceof VPPhraseSpec)) {
            verbPhrase.setFeature(featureName, featureValue);
        }
    }

    public Object getFeature(String featureName) {
        NLGElement verbPhrase;
        if (super.getFeature(featureName) != null) {
            return super.getFeature(featureName);
        }
        if (vpFeatures.contains(featureName) && ((verbPhrase = this.getFeatureAsElement("verb_phrase")) != null || verbPhrase instanceof VPPhraseSpec)) {
            return verbPhrase.getFeature(featureName);
        }
        return null;
    }

    public NLGElement getVerbPhrase() {
        return this.getFeatureAsElement("verb_phrase");
    }

    public void setVerbPhrase(NLGElement vp) {
        this.setFeature("verb_phrase", vp);
        vp.setParent(this);
    }

    public void setVerb(Object verb) {
        NLGElement verbPhraseElement = this.getVerbPhrase();
        if (verbPhraseElement != null && verbPhraseElement instanceof VPPhraseSpec) {
            ((VPPhraseSpec)verbPhraseElement).setVerb(verb);
        }
    }

    public NLGElement getVerb() {
        PhraseElement verbPhrase = (PhraseElement)this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null || verbPhrase instanceof VPPhraseSpec) {
            return verbPhrase.getHead();
        }
        return null;
    }

    public void setSubject(Object subject) {
        NLGElement subjectPhrase = subject instanceof PhraseElement || subject instanceof CoordinatedPhraseElement ? (NLGElement)subject : this.getFactory().createNounPhrase(subject);
        ArrayList<NLGElement> subjects = new ArrayList<NLGElement>();
        subjects.add(subjectPhrase);
        this.setFeature("subjects", subjects);
    }

    public NLGElement getSubject() {
        List<NLGElement> subjects = this.getFeatureAsElementList("subjects");
        if (subjects == null || subjects.isEmpty()) {
            return null;
        }
        return subjects.get(0);
    }

    public void setObject(Object object) {
        NLGElement verbPhraseElement = this.getVerbPhrase();
        if (verbPhraseElement != null && verbPhraseElement instanceof VPPhraseSpec) {
            ((VPPhraseSpec)verbPhraseElement).setObject(object);
        }
    }

    public NLGElement getObject() {
        PhraseElement verbPhrase = (PhraseElement)this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null || verbPhrase instanceof VPPhraseSpec) {
            return ((VPPhraseSpec)verbPhrase).getObject();
        }
        return null;
    }

    public void setIndirectObject(Object indirectObject) {
        NLGElement verbPhraseElement = this.getVerbPhrase();
        if (verbPhraseElement != null && verbPhraseElement instanceof VPPhraseSpec) {
            ((VPPhraseSpec)verbPhraseElement).setIndirectObject(indirectObject);
        }
    }

    public NLGElement getIndirectObject() {
        PhraseElement verbPhrase = (PhraseElement)this.getFeatureAsElement("verb_phrase");
        if (verbPhrase != null || verbPhrase instanceof VPPhraseSpec) {
            return ((VPPhraseSpec)verbPhrase).getIndirectObject();
        }
        return null;
    }

    public void addModifier(Object modifier) {
        String modifierString;
        if (modifier == null) {
            return;
        }
        NLGElement modifierElement = null;
        if (modifier instanceof NLGElement) {
            modifierElement = (NLGElement)modifier;
        } else if (modifier instanceof String && (modifierString = (String)modifier).length() > 0 && !modifierString.contains(" ")) {
            modifierElement = this.getFactory().createWord(modifier, LexicalCategory.ANY);
        }
        if (modifierElement == null) {
            this.addPostModifier((String)modifier);
            return;
        }
        if (modifierElement instanceof AdvPhraseSpec) {
            this.addPreModifier(modifierElement);
            return;
        }
        WordElement modifierWord = null;
        if (modifierElement != null && modifierElement instanceof WordElement) {
            modifierWord = (WordElement)modifierElement;
        } else if (modifierElement != null && modifierElement instanceof InflectedWordElement) {
            modifierWord = ((InflectedWordElement)modifierElement).getBaseWord();
        }
        if (modifierWord != null && modifierWord.getCategory() == LexicalCategory.ADVERB) {
            if (modifierWord.getFeatureAsBoolean("sentence_modifier").booleanValue()) {
                this.addFrontModifier(modifierWord);
            } else {
                this.addPreModifier(modifierWord);
            }
            return;
        }
        this.addPostModifier(modifierElement);
    }
}

