/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.system.rest;

import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.rest.server.AbstractContextResolver;
import com.ibm.smarts.core.rest.server.AbstractRestServerBuilder;
import com.ibm.smarts.core.rest.server.IRestServerConfiguration;
import com.ibm.smarts.core.rest.server.config.RestServerStaticConfig;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.system.SimpleSmartsAdaptor;
import com.ibm.smarts.system.SmartsSystem;
import com.ibm.smarts.system.rest.handlers.SystemModuleApi;
import com.ibm.smarts.system.rest.handlers.SystemPingApi;
import com.ibm.smarts.system.rest.handlers.SystemSemanticApi;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

public class SystemRestServerBuilder
extends AbstractRestServerBuilder {
    private final SmartsSystem<?> smartsSystem;

    public SystemRestServerBuilder(RequestContext requestContext, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, ExecutorService executorService) {
        super(requestContext, config);
        SimpleSmartsAdaptor adaptor = new SimpleSmartsAdaptor();
        this.smartsSystem = new SmartsSystem<SimpleSmartsAdaptor>(adaptor, config, dataProvider, storeProvider, messageQueueing, executorService);
    }

    public SystemRestServerBuilder(RequestContext requestContext, Properties config, SmartsSystem<?> smartsSystem) {
        super(requestContext, config);
        this.smartsSystem = smartsSystem;
    }

    public static RestServerStaticConfig staticConfig() {
        Class[] handlers = new Class[]{SystemPingApi.class, SystemModuleApi.class, SystemSemanticApi.class};
        RestServerStaticConfig ret = new RestServerStaticConfig(handlers);
        return ret;
    }

    public RestServerStaticConfig getStaticConfig() {
        return SystemRestServerBuilder.staticConfig();
    }

    public void addSingletonProviders(IRestServerConfiguration rsConfig) {
        rsConfig.addSingletonProvider((ContextResolver)new SmartsSystemContextResolver(this.smartsSystem));
    }

    @Provider
    public static class SmartsSystemContextResolver
    extends AbstractContextResolver<SmartsSystem<?>> {
        public SmartsSystemContextResolver(SmartsSystem<?> ss) {
            super(ss);
        }

        public SmartsSystem<?> getContext(Class<?> type) {
            return (SmartsSystem)this.getSingleton(type);
        }
    }
}

