/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.ca.core.impl.annotation.CaAnnotationClient;
import com.ibm.smarts.ca.core.impl.content.CaContentRestClient;
import com.ibm.smarts.ca.core.impl.content.CaMoserRestClient;
import com.ibm.smarts.ca.core.impl.contentrecommender.CaContentRecommenderClient;
import com.ibm.smarts.ca.core.impl.dashboardgenerator.CaDashboardGeneratorClient;
import com.ibm.smarts.ca.core.impl.frf.CaFRFClient;
import com.ibm.smarts.ca.core.impl.insights.CaInsightsClient;
import com.ibm.smarts.ca.core.impl.modeling.CaSmartsModelingClient;
import com.ibm.smarts.ca.core.impl.questiongenerator.CaQuestionGeneratorClient;
import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.ca.core.impl.useractions.CaUserActionRestClient;
import com.ibm.smarts.ca.core.impl.userprofile.CaUserProfileServiceRestClient;
import com.ibm.smarts.ca.core.rest.client.CaKnowledgeDiscoveryClient;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.rest.DatasetRestClient;
import com.ibm.smarts.common.rest.ModuleRestClient;
import com.ibm.smarts.common.rest.SmartsClientManager;
import com.ibm.smarts.common.rest.SmartsModuleRestClient;
import com.ibm.smarts.core.rest.client.util.RestClientManager;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;

public class SmartsCaClientManager
extends SmartsClientManager {
    public static final RestClientManager.RestClientType GENERIC_TYPE = new RestClientManager.RestClientType("generic");
    public static final RestClientManager.RestClientType CONTENT_TYPE = new RestClientManager.RestClientType("content");
    public static final RestClientManager.RestClientType SEARCH_TYPE = new RestClientManager.RestClientType("search");
    public static final RestClientManager.RestClientType KNOWLEDGE_DISCOVERY_TYPE = new RestClientManager.RestClientType("knowledgeDiscovery");
    public static final RestClientManager.RestClientType VISUALIZATION_RECOMMENDER_TYPE = new RestClientManager.RestClientType("VisRecommender");
    public static final RestClientManager.RestClientType INSIGHTS_TYPE = new RestClientManager.RestClientType("insights");
    public static final RestClientManager.RestClientType MODELING_TYPE = new RestClientManager.RestClientType("modeling");
    public static final RestClientManager.RestClientType MOSER_TYPE = new RestClientManager.RestClientType("moser");
    public static final RestClientManager.RestClientType USERS_TYPE = new RestClientManager.RestClientType("users");
    public static final RestClientManager.RestClientType FRF_TYPE = new RestClientManager.RestClientType("frf");
    public static final RestClientManager.RestClientType CONTENT_RECOMMENDER_TYPE = new RestClientManager.RestClientType("ContentRecommender");
    public static final RestClientManager.RestClientType USER_PROFILE_TYPE = new RestClientManager.RestClientType("userProfile");
    public static final RestClientManager.RestClientType ANNOTATION_TYPE = new RestClientManager.RestClientType("annotation");
    public static final RestClientManager.RestClientType DASHBOARD_GENERATOR_TYPE = new RestClientManager.RestClientType("DashboardGenerator");
    public static final RestClientManager.RestClientType QUESTION_GENERATOR_TYPE = new RestClientManager.RestClientType("questionGenerator");
    protected final Properties config;

    public SmartsCaClientManager(Properties config, RequestContext requestContext) {
        super(requestContext);
        this.config = config;
    }

    public CaRestClient getCaClient(final String baseUri) {
        return (CaRestClient)this.getClient(GENERIC_TYPE, baseUri, new Supplier<CaRestClient>(){

            @Override
            public CaRestClient get() {
                return new CaRestClient(SmartsCaClientManager.this.restCallContextFactory, SmartsCaClientManager.this.requestContext, baseUri);
            }
        });
    }

    public synchronized CaSearchClient getSearchClient() {
        CaSearchClient client = (CaSearchClient)((Object)this.clients.get(SEARCH_TYPE));
        if (client == null) {
            client = new CaSearchClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
            this.clients.put(SEARCH_TYPE, client);
        }
        return client;
    }

    public synchronized CaContentRestClient getContentClient() {
        CaContentRestClient client = (CaContentRestClient)((Object)this.clients.get(CONTENT_TYPE));
        if (client == null) {
            client = new CaContentRestClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
            this.clients.put(CONTENT_TYPE, client);
        }
        return client;
    }

    public synchronized CaDashboardGeneratorClient getDashboardGeneratorClient() {
        return (CaDashboardGeneratorClient)this.clients.computeIfAbsent(DASHBOARD_GENERATOR_TYPE, k -> new CaDashboardGeneratorClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaQuestionGeneratorClient getQuestionGeneratorClient() {
        return (CaQuestionGeneratorClient)this.clients.computeIfAbsent(QUESTION_GENERATOR_TYPE, k -> new CaQuestionGeneratorClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaContentRecommenderClient getContentRecommenderClient() {
        return (CaContentRecommenderClient)this.clients.computeIfAbsent(CONTENT_RECOMMENDER_TYPE, k -> new CaContentRecommenderClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaKnowledgeDiscoveryClient getKnowledgeDiscoveryClient() {
        CaKnowledgeDiscoveryClient client = (CaKnowledgeDiscoveryClient)((Object)this.clients.get(KNOWLEDGE_DISCOVERY_TYPE));
        if (client == null) {
            client = new CaKnowledgeDiscoveryClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
            this.clients.put(KNOWLEDGE_DISCOVERY_TYPE, client);
        }
        return client;
    }

    public synchronized CaSmartsModelingClient getSmartsModelingClient() {
        CaSmartsModelingClient client = (CaSmartsModelingClient)((Object)this.clients.get(MODELING_TYPE));
        if (client == null) {
            client = new CaSmartsModelingClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
            this.clients.put(MODELING_TYPE, client);
        }
        return client;
    }

    public synchronized CaMoserRestClient getMoserClient() {
        CaMoserRestClient client = (CaMoserRestClient)((Object)this.clients.get(MOSER_TYPE));
        if (client == null) {
            client = new CaMoserRestClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
            this.clients.put(MOSER_TYPE, client);
        }
        return client;
    }

    public synchronized DatasetRestClient getDatasetsClient() {
        return this.getDatasetsClient(this.config.getProperty("smarts.ca.core.caServer.url"));
    }

    public synchronized ModuleRestClient getModuleClient() {
        return this.getModuleClient(this.config.getProperty("smarts.ca.core.caServer.url"));
    }

    public synchronized SmartsModuleRestClient getSmartsModuleClient() {
        return this.getSmartsModuleClient(this.config.getProperty("smarts.ca.core.caServer.url"));
    }

    public synchronized CaInsightsClient getInsightsClient() {
        return (CaInsightsClient)this.clients.computeIfAbsent(INSIGHTS_TYPE, k -> new CaInsightsClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaFRFClient getFRFClient() {
        return (CaFRFClient)this.clients.computeIfAbsent(FRF_TYPE, k -> new CaFRFClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaUserActionRestClient getUsersClient() {
        return new CaUserActionRestClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url"));
    }

    public synchronized CaUserProfileServiceRestClient getUserProfileServiceClient() {
        return (CaUserProfileServiceRestClient)this.clients.computeIfAbsent(USER_PROFILE_TYPE, k -> new CaUserProfileServiceRestClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public synchronized CaAnnotationClient getAnnotationClient() {
        return (CaAnnotationClient)this.clients.computeIfAbsent(ANNOTATION_TYPE, k -> new CaAnnotationClient(this.restCallContextFactory, this.requestContext, this.config.getProperty("smarts.ca.core.caServer.url")));
    }

    public String toString() {
        return ToString.with((Object)((Object)this)).field("config", (Object)this.config).get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SmartsCaClientManager)) {
            return false;
        }
        SmartsCaClientManager clientManager = (SmartsCaClientManager)((Object)obj);
        return Objects.equals(this.config, clientManager.config);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }

    public static class SmartsCaClientManagerCreator
    implements ObjectCreator<SmartsCaClientManager> {
        public final Properties config;

        public static SmartsCaClientManagerCreator from(SmartsCaClientManager clientManager) {
            return new SmartsCaClientManagerCreator(clientManager.config);
        }

        @JsonCreator
        public SmartsCaClientManagerCreator(@JsonProperty(value="config") Properties config) {
            this.config = config;
        }

        public SmartsCaClientManager create(RequestContext requestContext) {
            return new SmartsCaClientManager(this.config, requestContext);
        }
    }
}

