/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.dashboardgenerator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.dashboardgenerator.ContentGroup;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Container {
    private final String label;
    private final String description;
    private final List<ContentGroup> groups = new ArrayList<ContentGroup>();
    private final boolean predictive;

    public Container(List<ContentGroup> groups) {
        this.label = null;
        this.description = null;
        this.groups.addAll(groups);
        this.predictive = false;
    }

    @JsonCreator
    public Container(@JsonProperty(value="label") String label, @JsonProperty(value="description") String description, @JsonProperty(value="groups") List<ContentGroup> groups, @JsonProperty(value="predictive") boolean isPredictive) {
        this.label = label;
        this.description = description;
        if (groups != null) {
            this.groups.addAll(groups);
        }
        this.predictive = isPredictive;
    }

    public boolean getPredictive() {
        return this.predictive;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ContentGroup> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals(this.getLabel(), container.getLabel()) && Objects.equals(this.getDescription(), container.getDescription()) && Objects.equals(this.getGroups(), container.getGroups()) && Objects.equals(this.predictive, container.predictive);
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"label", (Object)this.label);
        json.put((Object)"description", (Object)this.description);
        JSONArray jsonGroups = new JSONArray();
        this.groups.stream().forEach(c -> jsonGroups.add((Object)c.toJSONObjcet()));
        json.put((Object)"groups", (Object)jsonGroups);
        json.put((Object)"predictive", (Object)this.predictive);
        return json;
    }

    public int hashCode() {
        return Objects.hash(this.getLabel(), this.getDescription(), this.getGroups());
    }

    public String toString() {
        return "Container{label='" + this.label + '\'' + ", description='" + this.description + '\'' + ", groups=" + this.groups + ", predictive=" + this.predictive + '}';
    }
}

