/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.ca.core.impl.store.CaQueryBuilder;
import com.ibm.smarts.ca.core.impl.store.SmartsCaStoreBase;
import com.ibm.smarts.ca.core.impl.store.util.SmartsCaParserHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import javax.ws.rs.core.Response;

public class SmartsCaDataClueStore
extends SmartsCaStoreBase<DataClue>
implements IDataClueStore {
    public static final String DATA_CLUE_INDEX_NAME = "smarts_data_clue";
    private static final String DATA_CLUE_SCHEMA_RESOURCE_NAME = "dataClue.json";
    private final int BATCH_SIZE = 0x100000;
    private final int MAX_CONCURRENT_BATCHES = 10;
    private final int STEP_LENGTH = 10000;
    private final CompletionService<Void> completionSrvc = new ExecutorCompletionService<Void>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));

    public SmartsCaDataClueStore(StoreConfig storeConfig, CaSearchClient client) {
        super(storeConfig, client, DATA_CLUE_INDEX_NAME, DataClue.class);
    }

    @Override
    protected String schemaResourceName() {
        return DATA_CLUE_SCHEMA_RESOURCE_NAME;
    }

    @Override
    protected SmartsCaStoreBase.IndexingContext indexingContext() {
        return new BulkIndexingContext();
    }

    public StoreStatus delete(String ontoId, String tenantId) {
        throw new UnsupportedOperationException();
    }

    public StoreStatus delete(String ontoId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CaQueryBuilder queryBuilder() {
        return new DataClueQueryBuilder();
    }

    static class DataClueQueryBuilder
    extends CaQueryBuilder {
        DataClueQueryBuilder() {
        }

        @Override
        protected CaQueryBuilder.QueryBuilderContext context(IStoreQuery sq) {
            return new CaQueryBuilder.QueryBuilderContext(sq){

                @Override
                protected void buildInternal() {
                    if (!this.addDisMaxParams()) {
                        this.addDefaultQueryParam();
                    }
                    this.addFilterQueryParams();
                }
            };
        }
    }

    class BulkIndexingContext
    extends SmartsCaStoreBase.IndexingContext {
        BulkIndexingContext() {
        }

        void index(List<IRecord<DataClue>> records) {
            if (records.size() < 30000) {
                super.index(records);
                return;
            }
            int start = 0;
            while (start < records.size()) {
                int end = start + 10000;
                if (end > records.size()) {
                    end = records.size();
                }
                List<IRecord<DataClue>> subRecords = records.subList(start, end);
                start = end;
                List<BatchRequest> batches = null;
                try {
                    batches = this.collectBatches(subRecords);
                }
                catch (Throwable th) {
                    throw new InternalException("failed to collect batches for bulk indexing", new Object[]{th});
                }
                batches.stream().forEach(br -> SmartsCaDataClueStore.this.completionSrvc.submit(br));
                for (int received = 0; received < batches.size(); ++received) {
                    try {
                        SmartsCaDataClueStore.this.completionSrvc.take();
                        continue;
                    }
                    catch (Throwable th) {
                        throw new InternalException("failed bulk indexing", new Object[]{th});
                    }
                }
                SmartsCaStoreBase.LOGGER.debug("Finished bulk indexing of " + subRecords.size() + "  records");
            }
            SmartsCaStoreBase.LOGGER.debug("Finished bulk indexing of total " + records.size() + "  records");
        }

        List<BatchRequest> collectBatches(List<IRecord<DataClue>> records) throws Exception {
            ArrayList<BatchRequest> batches = new ArrayList<BatchRequest>();
            int i = 0;
            int batchID = 0;
            while (i < records.size()) {
                ArrayList<String> batch = new ArrayList<String>();
                ++batchID;
                int batchSize = 0;
                do {
                    IRecord<DataClue> record;
                    String recordJson;
                    if ((batchSize += (recordJson = SmartsCaParserHelper.serialize(record = records.get(i++))).getBytes("UTF-8").length) > 0x100000) {
                        --i;
                        break;
                    }
                    batch.add(recordJson);
                } while (i < records.size() && batchSize <= 0x100000);
                BatchRequest br = new BatchRequest();
                br.number = batchID;
                br.body = SmartsCaParserHelper.serializeToJsonBody(batch);
                batches.add(br);
            }
            return batches;
        }

        class BatchRequest
        implements Callable<Void> {
            int number;
            String body;

            BatchRequest() {
            }

            @Override
            public Void call() throws Exception {
                SmartsCaStoreBase.LOGGER.debug("Starting batch#" + this.number);
                Response response = BulkIndexingContext.this.indexSerialized(this.body);
                SmartsCaStoreBase.LOGGER.debug("Finished batch#" + this.number + " with response code:" + response.getStatus());
                return null;
            }
        }
    }
}

