/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.ca.core.impl.store.CaQueryBuilder;
import com.ibm.smarts.ca.core.impl.store.util.SmartsCaIndexHelper;
import com.ibm.smarts.ca.core.impl.store.util.SmartsCaParserHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.client.util.CompletableFutureHelper;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartsCaStoreBase<T> {
    protected final StoreConfig storeConfig;
    private final CaSearchClient client;
    private final String indexName;
    private final Class<T> klass;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SmartsCaStoreBase.class);

    public SmartsCaStoreBase(StoreConfig storeConfig, CaSearchClient client, String indexName, Class<T> klass) {
        this.storeConfig = storeConfig;
        this.client = client;
        this.indexName = indexName;
        this.klass = klass;
    }

    public final StoreStatus store(List<IRecord<T>> records) {
        try {
            SmartsCaIndexHelper indexHelper = new SmartsCaIndexHelper(this.client);
            String schemaResName = this.schemaResourceName();
            indexHelper.createIndexIfAbsent(this.indexName, schemaResName);
            this.indexingContext().index(records);
            LOGGER.debug("records stored in index '" + this.indexName + "' count: " + records.size());
            return new StoreStatus();
        }
        catch (Throwable ex) {
            String error = "failed to store records in index '" + this.indexName + "'";
            LOGGER.error(error, ex);
            return new StoreStatus(new InternalException(ex, error, new Object[0]));
        }
    }

    protected abstract String schemaResourceName();

    protected IndexingContext indexingContext() {
        return new IndexingContext();
    }

    public final List<IRecordResult<T>> executeSearch(IStoreQuery sq) {
        return SmartsCaStoreBase.get(this.executeSearchAsync(sq));
    }

    protected String primarySearchIndex() {
        return this.indexName;
    }

    public final CompletableFuture<List<IRecordResult<T>>> executeSearchAsync(IStoreQuery sq) {
        if (sq == null) {
            throw new IllegalArgumentException("store query cannot be null");
        }
        CompletableFuture ret = new CompletableFuture();
        String searchIndex = this.primarySearchIndex();
        try {
            ((CompletableFuture)this.search(searchIndex, sq).thenAccept(response -> {
                try {
                    if (this.client.handleIndexDoesNotExistResponse(searchIndex, (Response)response)) {
                        ret.complete(Collections.emptyList());
                        return;
                    }
                    String json = (String)response.getEntity();
                    List<IRecordResult<T>> records = SmartsCaParserHelper.deserialize(json, this.klass);
                    LOGGER.debug(records.size() + " records found in index '" + searchIndex + "' for query " + sq);
                    ret.complete(records);
                }
                catch (Throwable th) {
                    LOGGER.error("failed to search records in index '" + searchIndex + "' for query " + sq, th);
                    ret.completeExceptionally(th);
                }
            })).exceptionally(th -> {
                ret.completeExceptionally((Throwable)th);
                return null;
            });
        }
        catch (Throwable th2) {
            ret.completeExceptionally(th2);
        }
        return ret;
    }

    protected CompletableFuture<Response> search(String index, IStoreQuery sq) {
        return this.client.searchAsync(index, this.toQueryParams(sq));
    }

    protected final RestClient.QueryParams toQueryParams(IStoreQuery sq) {
        return this.queryBuilder().from(sq);
    }

    protected CaQueryBuilder queryBuilder() {
        return new CaQueryBuilder();
    }

    public final boolean isExist() {
        return this.client.indexExists(this.indexName);
    }

    public final IStoreQueryBuilder getQueryBuilder() {
        return new StoreQueryBuilder();
    }

    protected static <T> T get(CompletableFuture<T> cf) {
        return (T)CompletableFutureHelper.get(cf);
    }

    protected class IndexingContext {
        protected IndexingContext() {
        }

        void index(List<IRecord<T>> records) {
            String serialized = SmartsCaParserHelper.serializeToJsonBody(records.stream().map(r -> SmartsCaParserHelper.serialize(r)).collect(Collectors.toList()));
            this.indexSerialized(serialized);
        }

        final Response indexSerialized(String serializedRecords) {
            return SmartsCaStoreBase.this.client.storeSerialized(SmartsCaStoreBase.this.indexName, serializedRecords);
        }
    }
}

