/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisScopes;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;

public class SmartsPersistenceProvider
implements IPersistenceProvider {
    IInMemoryModuleStore moduleStore;

    public SmartsPersistenceProvider(IInMemoryModuleStore store) {
        this.moduleStore = store;
    }

    @Override
    public IRecord<SmartsModule> get(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        SmartsModule smartsModule = this.moduleStore.getById(moduleId);
        SmartsModuleUtil.filterSmartsModuleByOptions((SmartsModule)smartsModule, (SmartsModuleOptions)smartsModuleOptions);
        Map<Object, Object> urlMap = Collections.emptyMap();
        if (smartsModule != null) {
            urlMap = smartsModule.getDatasets().stream().collect(Collectors.toMap(ds -> ds.getId(), ds -> IInMemoryModuleStore.buildDatasetCompositeId(moduleId, ds.getId())));
            urlMap.put("SmartsModule", IInMemoryModuleStore.buildDatasetCompositeId(moduleId, "SmartsModule"));
        }
        return IRecord.create((Object)this.moduleStore.getById(moduleId), (String)moduleId, (String)"", urlMap);
    }

    @Override
    public CompletableFuture<IRecord<SmartsModule>> getAsync(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        throw new NotImplementedException("getAsync is not implemented in Smarts permanent store");
    }

    @Override
    public StoreStatus create(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> moduleRecord, List<String> tags) {
        return this.store(requestContext, moduleRecord, smartsModuleName, tags, null);
    }

    @Override
    public StoreStatus update(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> modulePartRecord, List<String> tags, String resourceURI) {
        return this.store(requestContext, modulePartRecord, smartsModuleName, tags, resourceURI);
    }

    @Override
    public StoreStatus delete(RequestContext requestContext, String moduleId, String moduleRecordVersion, List<String> listUri) {
        if (listUri != null && !listUri.isEmpty()) {
            return new StoreStatus(false, null);
        }
        return this.moduleStore.deleteById(moduleId);
    }

    @Override
    @Nonnull
    public SmartsModule getProgress(@Nonnull RequestContext requestContext, @Nonnull String moduleId, @Nonnull AnalysisScope analysisScope, @Nonnull SmartsModuleOptions smartsModuleOptions) {
        SmartsModule smartsModule = this.moduleStore.getSmartsModulePart(moduleId, "SmartsModule");
        if (smartsModule != null) {
            HashSet datasetName = new HashSet(AnalysisScopes.getInScopeTableNames((AnalysisScope)analysisScope));
            if (!datasetName.isEmpty()) {
                smartsModule.getDatasets().removeIf(datasetInfo -> !datasetName.contains(datasetInfo.getId()));
                smartsModule.setAnalysisState(SmartsUtil.calculateState((SmartsModule)smartsModule));
            }
        } else {
            throw new IllegalArgumentException("No SmartsModule exists with id" + moduleId);
        }
        return smartsModule;
    }

    @Override
    public SmartsModule getById(RequestContext requestContext, String moduleId) {
        return this.moduleStore.getById(moduleId);
    }

    @Override
    public SmartsModule getByIdAndTags(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        return this.getById(requestContext, moduleId);
    }

    @Override
    public StoreStatus createOrReplace(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> modulePartRecord, List<String> tags, String resourceURI) {
        return this.store(requestContext, modulePartRecord, smartsModuleName, tags, resourceURI);
    }

    private StoreStatus store(RequestContext requestContext, IRecord<SmartsModule> moduleRecord, String smartsModulePartId, List<String> tags, String resourceURI) {
        String smartsModuleId = moduleRecord.getId();
        IRecord smartsModulePart = IRecord.create((Object)moduleRecord.getRecord(), (String)smartsModulePartId);
        try {
            return this.moduleStore.store((IRecord<SmartsModule>)smartsModulePart, smartsModuleId);
        }
        catch (RecordAlreadyExistsException e) {
            SmartsModule part = (SmartsModule)moduleRecord.getRecord();
            if ("SmartsModule".equals(smartsModulePartId)) {
                return this.moduleStore.apply(smartsModuleId, sm -> {
                    try {
                        return (SmartsModule)part.clone();
                    }
                    catch (CloneNotSupportedException e1) {
                        throw new InternalException("Failed to clone SmartsModule {0}, Dataset {1} ", new Object[]{smartsModuleId, smartsModulePartId});
                    }
                });
            }
            if (part.getDatasets().isEmpty()) {
                throw new IllegalArgumentException("SmartsModule Part has no Dataset");
            }
            return this.moduleStore.apply(smartsModuleId, smartsModulePartId, ds -> (DatasetInfo)part.getDatasets().get(0));
        }
    }
}

