/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.schema.entity;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;

public class ColumnModifierEntity
extends Entity {
    private Order order;
    private Aggregator aggregator;
    private Limit limit;

    public ColumnModifierEntity(JSONObject entity) {
        super(entity);
        String aggregatorName;
        String orderName = (String)entity.get((Object)"order");
        if (orderName != null) {
            this.setOrder(Order.fromName(orderName));
        }
        if ((aggregatorName = (String)entity.get((Object)"aggregator")) != null) {
            this.setAggregator(Aggregator.fromName(aggregatorName));
        }
        if (entity.get((Object)"limit") != null) {
            this.limit = new Limit((JSONObject)entity.get((Object)"limit"));
        }
    }

    public ColumnModifierEntity(String text, long start, long end, String extractor) {
        super("columnModifier", text, start, end, extractor);
        this.setOrder(Order.fromValue(text));
        this.setAggregator(Aggregator.fromValue(text));
    }

    public ColumnModifierEntity(String id, String text, long start, long end, String extractor, String instanceOf) {
        super(id, text, start, end, extractor, instanceOf);
        this.setOrder(Order.fromValue(text));
        this.setAggregator(Aggregator.fromValue(text));
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public void setLimit(String limit, boolean isPercent) {
        this.limit = new Limit(limit, isPercent);
    }

    public Limit getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public String toString() {
        return "Column Modifier [" + this.getBasicString() + ", order=" + (Object)((Object)this.order) + ", aggregator=" + (Object)((Object)this.aggregator) + ", limit=" + this.limit + "]";
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.order != null) {
            json.put((Object)"order", (Object)this.order.name());
        }
        if (this.aggregator != null) {
            json.put((Object)"aggregator", (Object)this.aggregator.name());
        }
        if (this.limit != null) {
            json.put((Object)"limit", (Object)this.limit.toJSON());
        }
        return json;
    }
}

