/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.schema.entity;

import com.ibm.json.java.JSONObject;

public class Entity
implements Comparable<Entity>,
Cloneable {
    private String id;
    protected Object value;
    protected String text;
    private long start;
    private long end;
    private String extractor;
    private String instanceOf;
    public static final String COLUMN = "column";
    public static final String COLUMN_MODIFIER = "columnModifier";
    public static final String SOURCE = "source";
    public static final String FILTER = "filter";
    public static final String TIME = "time";
    public static final String NUMBER = "number";
    public static final String PERCENT = "percent";
    public static final String OPERATOR = "operator";
    public static final String NER_DUCKLING = "ner_duckling";
    public static final String NER_QIF = "ner_qif";
    public static final String NER_CRF = "ner_crf";
    public static final String NER_SEMANTIC = "ner_semantic";
    public static final String NER_NLP = "ner_nlp";

    public Entity(String id, String text, long start, long end, String extractor) {
        this.id = id;
        this.text = text;
        this.value = this.text;
        this.start = start;
        this.end = end;
        this.extractor = extractor;
    }

    public Entity(String id, String text, long start, long end, String extractor, String instanceOf) {
        this(id, text, start, end, extractor);
        this.instanceOf = instanceOf;
    }

    public Entity(JSONObject json) {
        this.id = (String)json.get((Object)"entity");
        this.start = (Long)json.get((Object)"start");
        this.end = (Long)json.get((Object)"end");
        this.extractor = (String)json.get((Object)"extractor");
        this.instanceOf = (String)json.get((Object)"instanceOf");
        this.text = (String)json.get((Object)"text");
        this.readValue(json);
    }

    protected void readValue(JSONObject json) {
        this.value = json.get((Object)"value");
        this.value = this.value == null ? null : this.value.toString();
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"entity", (Object)this.id);
        json.put((Object)"start", (Object)this.start);
        json.put((Object)"end", (Object)this.end);
        json.put((Object)"extractor", (Object)this.extractor);
        json.put((Object)"text", (Object)this.text);
        json.put((Object)"value", this.value);
        json.put((Object)"instanceOf", (Object)this.instanceOf);
        return json;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public Object getValue() {
        return this.value;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getExtractor() {
        return this.extractor;
    }

    public void setExtractor(String extractor) {
        this.extractor = extractor;
    }

    private String getInstanceOf() {
        return this.instanceOf;
    }

    private boolean isExtractedBy(String extractor) {
        return extractor.equals(this.extractor);
    }

    public boolean isExtractedByCRF() {
        return this.isExtractedBy(NER_CRF);
    }

    public boolean isExtractedBySemanticSearch() {
        return this.isExtractedBy(NER_SEMANTIC);
    }

    public boolean isColumn() {
        return this.isEntityType(COLUMN);
    }

    public boolean isColumnModifier() {
        return this.isEntityType(COLUMN_MODIFIER);
    }

    public boolean isSource() {
        return this.isEntityType(SOURCE);
    }

    public boolean isTime() {
        return this.isEntityType(TIME);
    }

    public boolean isNumber() {
        return this.isEntityType(NUMBER);
    }

    public boolean isPercent() {
        return this.isEntityType(PERCENT);
    }

    public boolean isOperator() {
        return this.isEntityType(OPERATOR);
    }

    public boolean isEntityType(String id) {
        return id.equals(this.getId()) || id.equals(this.getInstanceOf());
    }

    public boolean contains(Entity e2) {
        return e2.getStart() >= this.getStart() && e2.getEnd() <= this.getEnd();
    }

    public boolean partiallyContains(Entity e2) {
        return e2.getStart() >= this.start && e2.getStart() <= this.end || e2.getEnd() >= this.start && e2.getEnd() <= this.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    @Override
    public int compareTo(Entity e2) {
        Entity e1 = this;
        if (e1.getStart() < e2.getStart()) {
            return -1;
        }
        if (e1.getStart() == e2.getStart()) {
            if (e1.getEnd() < e2.getEnd()) {
                return -1;
            }
            if (e1.getEnd() == e2.getEnd()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public Entity clone() throws CloneNotSupportedException {
        return (Entity)super.clone();
    }

    public String toString() {
        return "Entity [" + this.getBasicString() + "]";
    }

    private String getValueString() {
        return this.value == null ? "null" : this.value.toString();
    }

    protected String getBasicString() {
        return "id=" + this.id + ", text=" + this.text + ", value=" + this.getValueString() + ", start=" + this.start + ", end=" + this.end + ", extractor=" + this.extractor;
    }
}

