/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.schema.intent;

import com.ibm.smarts.conversation.nlu.schema.utils.ColumnModifierUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum Order {
    ASC("bottomcount"),
    DESC("topcount");

    private final String value;
    private static final List<String> KEYWORD_ASC;
    private static final List<String> KEYWORD_DESC;

    private Order(String value) {
        this.value = value;
    }

    public static Order fromValue(String modifier) {
        if (modifier != null) {
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_ASC) != null) {
                return ASC;
            }
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_DESC) != null) {
                return DESC;
            }
        }
        return null;
    }

    public static Order fromName(String name) {
        Optional<Order> order = Arrays.stream(Order.values()).filter(v -> v.name().equals(name)).findFirst();
        if (order.isPresent()) {
            return order.get();
        }
        return null;
    }

    public String value() {
        return this.value;
    }

    static {
        KEYWORD_ASC = Arrays.asList("bottom", "worst", "least", "lowest");
        KEYWORD_DESC = Arrays.asList("top", "most", "best", "highest");
    }
}

