/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.client.simple.SimpleJaxrsResponse;
import com.ibm.smarts.core.rest.client.simple.SimpleRestClient;
import com.ibm.smarts.core.rest.client.simple.SimpleRestClientConfig;
import com.ibm.smarts.core.rest.client.simple.SimpleRestClientFactory;
import com.ibm.smarts.core.rest.client.util.JaxRs20Classes;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.rest.client.util.JaxRs20Helper;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;

public class SimpleRestCallContext<T>
extends RestClient.AbstractRestCallContext<T>
implements RestClient.RestCallContext<T> {
    private final SimpleRestClientFactory factory;
    private final SimpleRestClientConfig clientConfig;
    private final String pathRoot;

    public SimpleRestCallContext(RequestContext requestContext, Class<T> klass, SimpleRestClientFactory factory, RestClient.MeasuredFuture<T> mf, final String root, String path, RestClient.QueryParams params, MediaType mediaType, Map<String, List<String>> headers, Map<String, NewCookie> setCookies) {
        super(requestContext, klass, mf, root, path, params, mediaType, headers, setCookies);
        String string;
        this.factory = factory;
        this.clientConfig = new LocalRESTClientConfig(){

            public String getDefaultAddress() {
                return root;
            }
        };
        for (String string2 : headers.keySet()) {
            List<String> values = headers.get(string2);
            if (values == null || values.isEmpty()) continue;
            String value = values.get(0);
            this.clientConfig.setRequestHeader(string2, value);
        }
        Collection<Header> configHeaders = this.clientConfig.getRequestHeaders();
        for (Header configHeader : configHeaders) {
            String name = configHeader.getName();
            if (headers.containsKey(name)) continue;
            String value = configHeader.getValue();
            List<String> ourValue = headers.get(name);
            if (ourValue == null) {
                ourValue = new ArrayList<String>();
                headers.put(name, ourValue);
            }
            ourValue.add(value);
        }
        String string3 = "";
        try {
            URL url = new URL(root);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            URL shortUrl = new URL(protocol, host, port, "");
            String shortRoot = shortUrl.toString();
            string = root.substring(shortRoot.length());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e, "Building URL from '" + root + "'", new Object[0]);
        }
        this.pathRoot = string;
    }

    @Override
    public String buildPath(String path) {
        return super.buildPath(this.root + path);
    }

    private Future<T> executeCall(String verb, final JaxRs20Classes.InvocationCallback<T> callback, final RestExecutor func, String callBody) {
        this.verb = verb;
        this.reportCall(callBody);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SimpleRestClient client = null;
                try {
                    boolean trustWorked = false;
                    client = SimpleRestCallContext.this.factory.getClient(SimpleRestCallContext.this.clientConfig);
                    int status = func.apply(client);
                    Object object = null;
                    try {
                        object = SimpleRestCallContext.this.buildResponseObject(status, client);
                        callback.completed(object);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                }
                catch (Exception e2) {
                    callback.failed(e2);
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        runnable.run();
        return this.mf;
    }

    private Future<T> executeCall(String verb, JaxRs20Classes.InvocationCallback<T> callback, RestExecutor func) {
        return this.executeCall(verb, callback, func, "");
    }

    @Override
    public Future<T> get(JaxRs20Classes.InvocationCallback<T> callback) {
        return this.executeCall("GET", callback, client -> client.getResource(this.buildPath(this.path)));
    }

    @Override
    public Future<T> get(JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.executeCall("GET", callback, client -> client.getResource(this.buildPath(this.path)));
    }

    @Override
    public Future<T> put(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.put(entity, callback);
    }

    @Override
    public Future<T> put(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback) {
        return this.executeCall("PUT", callback, client -> {
            Object item = entity.getEntity();
            if (item != null) {
                if (item instanceof InputStream) {
                    InputStream is = (InputStream)item;
                    return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), -1L, is);
                }
                if (!(item instanceof String)) throw new InternalException("Unexpected entity in PUT: class=" + entity.getClass().getName() + " entity=" + entity, new Object[0]);
                String json = (String)item;
                JsonNode jsonObject = JsonParserHelper.parseJson((String)json);
                return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
            }
            String json = "{}";
            JsonNode jsonObject = JsonParserHelper.parseJson((String)"{}");
            return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
        });
    }

    @Override
    public Future<T> post(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback) {
        Object item = entity.getEntity();
        String body = item != null ? item.toString() : "";
        return this.executeCall("POST", callback, client -> this.postHandler(entity, client), body);
    }

    @Override
    public Future<T> post(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        Object item = entity.getEntity();
        String body = item != null ? item.toString() : "";
        return this.executeCall("POST", callback, client -> this.postHandler(entity, client), body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int postHandler(JaxRs20Classes.Entity<?> entity, SimpleRestClient client) throws IOException {
        Object item = entity.getEntity();
        if (item != null) {
            if (item instanceof InputStream) {
                InputStream is = (InputStream)item;
                return client.createResource(this.buildPath(this.path), this.mediaType.toString(), -1L, is);
            }
            if (item instanceof String) {
                String json = (String)item;
                JsonNode jsonObject = JsonParserHelper.parseJson((String)json);
                return client.createResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
            }
            if (!(item instanceof HttpEntity)) throw new InternalException("Unexpected entity in POST: class=" + entity.getClass().getName() + " entity=" + entity, new Object[0]);
            return client.createResource(this.buildPath(this.path), (HttpEntity)item);
        }
        String json = "{}";
        JsonNode jsonObject = JsonParserHelper.parseJson((String)"{}");
        return client.createResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
    }

    @Override
    public Future<T> delete(JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.delete(callback);
    }

    @Override
    public Future<T> delete(JaxRs20Classes.InvocationCallback<T> callback) {
        return this.executeCall("DELETE", callback, client -> {
            int status = client.deleteResource(this.buildPath(this.path), this.mediaType.toString());
            return status;
        });
    }

    private T buildResponseObject(int status, SimpleRestClient client) throws Exception {
        boolean isOkStatus;
        T result = null;
        SimpleJaxrsResponse response = this.buildBIResponse(status, client);
        Response.StatusType statusType = response.getStatusInfo();
        boolean bl = statusType == null ? false : (isOkStatus = statusType.getFamily() == Response.Status.Family.SUCCESSFUL);
        if (this.klass == Response.class) {
            result = this.klass.cast((Object)response);
        } else if (isOkStatus) {
            result = response.readEntity(this.klass);
        } else {
            JaxRs20Exceptions.ProcessingException processingException = this.convertToException(response);
            throw processingException;
        }
        return result;
    }

    private void dumpClass(String header, Class<?> k) {
        System.out.println(" DUMPING CLASS " + header);
        for (Class<?> curr = k; curr != null; curr = curr.getSuperclass()) {
            System.out.println("  " + curr + " @" + Integer.toHexString(curr.hashCode()));
        }
    }

    @Override
    public JaxRs20Exceptions.ProcessingException buildException(Response resp) {
        JaxRs20Exceptions.ProcessingException ret = this.convertToException(resp);
        return ret;
    }

    private JaxRs20Exceptions.ProcessingException convertToException(Response response) {
        try {
            WebApplicationException webAppException;
            int statusCode = response.getStatus();
            Response.Status status = Response.Status.fromStatusCode((int)statusCode);
            Response.Status.Family statusFamily = JaxRs20Helper.familyForStatus(statusCode);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRestUri());
            sb.append(" headers=" + ToString.valueString((Object)this.headers));
            sb.append(" setCookies=" + ToString.valueString((Object)this.setCookies));
            String messageDetails = sb.toString();
            if (status == null) {
                webAppException = this.createExceptionForFamily(messageDetails, response, statusFamily);
            } else {
                int METHOD_NOT_ALLOWED = 405;
                if (statusCode == 405) {
                    webAppException = new JaxRs20Exceptions.NotAllowedException(messageDetails, response);
                } else {
                    switch (status) {
                        case BAD_REQUEST: {
                            webAppException = new JaxRs20Exceptions.BadRequestException(messageDetails, response);
                            break;
                        }
                        case UNAUTHORIZED: {
                            webAppException = new JaxRs20Exceptions.NotAuthorizedException(messageDetails, response);
                            break;
                        }
                        case FORBIDDEN: {
                            webAppException = new JaxRs20Exceptions.ForbiddenException(messageDetails, response);
                            break;
                        }
                        case NOT_FOUND: {
                            webAppException = new JaxRs20Exceptions.NotFoundException(messageDetails, response);
                            break;
                        }
                        case NOT_ACCEPTABLE: {
                            webAppException = new JaxRs20Exceptions.NotAcceptableException(messageDetails, response);
                            break;
                        }
                        case UNSUPPORTED_MEDIA_TYPE: {
                            webAppException = new JaxRs20Exceptions.NotSupportedException(messageDetails, response);
                            break;
                        }
                        case INTERNAL_SERVER_ERROR: {
                            webAppException = new JaxRs20Exceptions.InternalServerErrorException(messageDetails, response);
                            break;
                        }
                        case SERVICE_UNAVAILABLE: {
                            webAppException = new JaxRs20Exceptions.ServiceUnavailableException(messageDetails, response);
                            break;
                        }
                        default: {
                            webAppException = this.createExceptionForFamily(messageDetails, response, statusFamily);
                        }
                    }
                }
            }
            return new JaxRs20Exceptions.ResponseProcessingException(response, (Throwable)webAppException);
        }
        catch (Throwable t) {
            return new JaxRs20Exceptions.ResponseProcessingException(response, t);
        }
    }

    private WebApplicationException createExceptionForFamily(String message, Response response, Response.Status.Family statusFamily) {
        JaxRs20Exceptions.LocalWebApplicationException webAppException;
        if (statusFamily != null) {
            switch (statusFamily) {
                case REDIRECTION: {
                    webAppException = new JaxRs20Exceptions.RedirectionException(message, response);
                    break;
                }
                case CLIENT_ERROR: {
                    webAppException = new JaxRs20Exceptions.ClientErrorException(message, response);
                    break;
                }
                case SERVER_ERROR: {
                    webAppException = new JaxRs20Exceptions.ServerErrorException(message, response);
                    break;
                }
                default: {
                    webAppException = new JaxRs20Exceptions.LocalWebApplicationException(message, response);
                    break;
                }
            }
        } else {
            webAppException = new JaxRs20Exceptions.LocalWebApplicationException(message, response);
        }
        return webAppException;
    }

    private SimpleJaxrsResponse buildBIResponse(int status, SimpleRestClient client) {
        Header[] respHeaders = client.getResponseHeaders();
        InputStream respStream = null;
        String respBody = null;
        try {
            respStream = client.getResponseStream();
            if (respStream != null) {
                respBody = IOUtils.toString((InputStream)respStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respStream != null && respStream != null) {
            try {
                respStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (Header h : respHeaders) {
            String name = h.getName();
            if (!headers.containsKey(name)) {
                headers.put(name, new ArrayList());
            }
            HeaderElement[] elems = h.getElements();
            List values = (List)headers.get(name);
            String value = h.getValue();
            values.add(value);
            headers.put(name, values);
        }
        SimpleJaxrsResponse ret = new SimpleJaxrsResponse(status, headers, respBody);
        return ret;
    }

    private static interface RestExecutor {
        public int apply(SimpleRestClient var1) throws Exception;
    }

    private static class LocalRESTClientConfig
    extends SimpleRestClientConfig {
    }
}

