/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.ibm.smarts.core.rest.server.AbstractRestEngine;
import com.ibm.smarts.core.rest.server.IRestEngineBuilder;
import com.ibm.smarts.core.rest.server.IRestServerBuilder;
import com.ibm.smarts.core.rest.server.RestServerConfiguration;
import com.ibm.smarts.core.rest.server.config.RestServerProps;
import com.ibm.smarts.core.rest.server.config.RestServerStaticConfig;
import com.ibm.smarts.core.util.ConfigUtil;
import com.ibm.smarts.core.util.RequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestServer {
    protected final RequestContext requestContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRestServer.class);
    protected final Properties config;
    private final List<IRestServerBuilder> serverBuilders = new ArrayList<IRestServerBuilder>();
    public final RestServerConfiguration serverConfig;
    private final IRestEngineBuilder engineBuilder;
    public AbstractRestEngine engine;

    public AbstractRestServer(IRestEngineBuilder engineBuilder) {
        this(AbstractRestServer.buildRestServerConfig(), engineBuilder);
    }

    public AbstractRestServer(Properties config_, IRestEngineBuilder engineBuilder_) {
        Properties restConfig;
        this.config = config_;
        this.requestContext = new RequestContext(Locale.US, Locale.ENGLISH);
        this.engineBuilder = engineBuilder_;
        if (engineBuilder_ != null) {
            restConfig = AbstractRestServer.buildRestServerConfig(this.config);
            LOGGER.info("REST server config: " + restConfig);
        } else {
            restConfig = null;
        }
        this.serverConfig = new RestServerConfiguration(restConfig);
    }

    protected void addBuilder(IRestServerBuilder bldr) {
        this.serverBuilders.add(bldr);
    }

    public void build() {
        for (IRestServerBuilder bldr : this.serverBuilders) {
            RestServerStaticConfig sc = bldr.getStaticConfig();
            if (sc != null) {
                this.serverConfig.addStaticConfig(sc);
            }
            bldr.addSingletonProviders(this.serverConfig);
        }
        if (this.engineBuilder != null) {
            this.engine = this.engineBuilder.buildRestEngine(this.requestContext, this.serverConfig);
        }
    }

    public void run() {
        if (this.engine != null) {
            this.engine.start();
        }
    }

    public void stop() {
        if (this.engine != null) {
            this.engine.stop();
        }
    }

    private static Properties buildRestServerConfig() {
        return AbstractRestServer.buildRestServerConfig(new Properties());
    }

    private static Properties buildRestServerConfig(Properties config) {
        return ConfigUtil.updateProps((Properties)RestServerProps.getDefaultConfig(), (Properties)config);
    }
}

