/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.server.AbstractRestServer;
import com.ibm.smarts.core.rest.server.AbstractRestServiceContextListener;
import com.ibm.smarts.core.rest.server.config.RestServerStaticConfig;
import com.ibm.smarts.core.util.RequestContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestService
extends Application {
    public static RequestContext systemRequestContext;
    private static final Logger LOGGER;
    protected AbstractRestServer server;
    private static final List<Class<?>> baseClasses;

    public AbstractRestService() {
        LOGGER.info("Creating REST service");
        this.server = AbstractRestServiceContextListener.getServer();
    }

    protected void checkServer() {
        if (this.server == null) {
            throw new InternalException("Server is not set", new Object[0]);
        }
    }

    public Set<Class<?>> getClasses() {
        this.checkServer();
        LOGGER.info("Getting handler classes...");
        HashSet ret = new HashSet();
        ret.addAll(baseClasses);
        RestServerStaticConfig c = this.server.serverConfig.getStaticConfig();
        for (Class<?> klass : c.handlerPackages) {
            LOGGER.info("  handler class: " + klass.getName());
            ret.add(klass);
        }
        return ret;
    }

    public Set<Object> getSingletons() {
        this.checkServer();
        LOGGER.info("Getting singletons...");
        HashSet<Object> ret = new HashSet<Object>();
        List<ContextResolver<?>> sps = this.server.serverConfig.getSingletonProviders();
        for (ContextResolver<?> cr : sps) {
            LOGGER.info("  singleton: " + cr);
            ret.add(cr);
        }
        return ret;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AbstractRestService.class);
        baseClasses = Arrays.asList(JsonMappingExceptionMapper.class, JsonParseExceptionMapper.class, JacksonJsonProvider.class);
    }
}

