/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.datatype;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypeDeserializer;
import com.ibm.smarts.model.datatype.DataTypeSerializer;
import com.ibm.smarts.model.value.StringValue;
import com.ibm.smarts.model.value.Value;

@JsonTypeName(value="string")
@JsonDeserialize(using=DataTypeDeserializer.class)
@JsonSerialize(using=DataTypeSerializer.class)
public class StringType
extends DataType {
    private int maxLength;

    public StringType(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength must be > 0");
        }
        this.maxLength = maxLength;
    }

    public StringType() {
        this.maxLength = Integer.MAX_VALUE;
    }

    @Override
    public BaseDataType getBaseType() {
        return BaseDataType.STRING;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public StringType withMaxLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength must be > 0");
        }
        if (this.maxLength == maxLength) {
            return this;
        }
        return new StringType(maxLength);
    }

    @Override
    public Value newValue() {
        return new StringValue(this);
    }

    @Override
    public String toString() {
        return "string(" + this.maxLength + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringType)) {
            return false;
        }
        StringType other = (StringType)o;
        return this.maxLength == other.maxLength;
    }

    public int hashCode() {
        return this.getBaseType().hashCode() + this.maxLength;
    }
}

