/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.ibm.smarts.model.value.Value;
import java.io.IOException;

public class ValueSerializer
extends StdSerializer<Value> {
    private static final long serialVersionUID = -537974210957426114L;

    public ValueSerializer() {
        super(Value.class);
    }

    protected ValueSerializer(Class<Value> t) {
        super(t);
    }

    public void serializeWithType(Value value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jgen, provider);
    }

    public void serialize(Value value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("type", value.getType().getBaseType().name().toLowerCase());
        jgen.writeStringField("status", value.getStatus().name());
        switch (value.getType().getBaseType()) {
            case BOOLEAN: {
                jgen.writeBooleanField("booleanValue", value.booleanValue());
                break;
            }
            case BYTE: {
                jgen.writeNumberField("byteValue", (short)value.byteValue());
                break;
            }
            case SHORT: {
                jgen.writeNumberField("shortValue", value.shortValue());
                break;
            }
            case INTEGER: {
                jgen.writeNumberField("integerValue", value.intValue());
                break;
            }
            case LONG: {
                jgen.writeNumberField("longValue", value.longValue());
                break;
            }
            case FLOAT: {
                jgen.writeNumberField("floatValue", value.floatValue());
                break;
            }
            case DOUBLE: {
                jgen.writeNumberField("doubleValue", value.doubleValue());
                break;
            }
            case DECIMAL: {
                jgen.writeNumberField("decimalValue", value.bigDecimalValue());
                break;
            }
            case DATE: 
            case TIMESTAMP: 
            case TIME: {
                jgen.writeNumberField("timeInMillis", value.doubleValue());
                break;
            }
            case STRING: {
                jgen.writeStringField("stringValue", value.stringValue());
                break;
            }
            case UNKNOWN: {
                if (value.stringValue() == null) break;
                jgen.writeStringField("stringValue", value.stringValue());
            }
        }
        jgen.writeEndObject();
    }
}

