/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.http.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalAddresses {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalAddresses.class);
    static LoadingCache<String, Set<String>> cache = CacheBuilder.newBuilder().maximumSize(2L).refreshAfterWrite(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Set<String>>(){

        public Set<String> load(String key) throws Exception {
            return LocalAddresses.makeLocalAddressSet();
        }
    });

    private LocalAddresses() {
    }

    static Set<String> makeLocalAddressSet() {
        HashSet<String> localAddresses = new HashSet<String>();
        try {
            localAddresses.add(InetAddress.getLocalHost().getHostAddress());
            InetAddress[] en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> ipAddrs = intf.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    String addr = ipAddrs.nextElement().getHostAddress();
                    if (StringUtils.contains((String)addr, (String)"%")) {
                        addr = StringUtils.substringBefore((String)addr, (String)"%");
                    }
                    localAddresses.add(addr);
                }
            }
            for (InetAddress inetAddress : InetAddress.getAllByName("localhost")) {
                localAddresses.add(inetAddress.getHostAddress());
            }
            LOGGER.trace("Local ip addresses:" + localAddresses);
        }
        catch (SocketException | UnknownHostException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        return localAddresses;
    }

    public static boolean isLocal(String address) {
        try {
            if (StringUtils.contains((String)address, (String)"%")) {
                address = StringUtils.substringBefore((String)address, (String)"%");
            }
            return ((Set)cache.get((Object)"localaddresses")).contains(address);
        }
        catch (ExecutionException e) {
            LOGGER.error("unexpected exception testing address", (Throwable)e);
            return false;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("Error getting hostname", (Throwable)e);
            return "unknown";
        }
    }
}

