/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.Service;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status {
    private static final Logger LOGGER = LoggerFactory.getLogger(Status.class);
    private int code;
    private String key;
    private String message;
    private String service;

    @JsonCreator
    public Status(@JsonProperty(value="code") int code, @JsonProperty(value="key") String key, @JsonProperty(value="message") String message, @JsonProperty(value="service") String service) {
        this.code = code;
        this.key = key;
        this.message = message;
        this.service = service;
    }

    public Status(int code, String key, String message, Service service) {
        this(code, key, message, service.getServiceName());
    }

    public Status(int code, String key, Service service) {
        this(code, key, "", service.getServiceName());
    }

    public int getCode() {
        return this.code;
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.message;
    }

    public String getService() {
        return this.service;
    }

    public static Status fromJSON(String str) {
        try {
            return CommonJAXBHelper.unmarshalFromJSON(Status.class, str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Unable to deserialize JSON in the Status class", (Throwable)e);
            return null;
        }
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON(this, true);
    }
}

