/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.pipeline;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SmartsTaskContext
implements IContext {
    public static final String NLP_PROPERTY = "nlp";
    public static final String DATA_PROVIDER_PROPERTY = "dataProvider";
    public static final String SAMPLE_QUERY_CONTEXT_PROPERTY = "SampleQueryContext";
    public static final String MODULE_HAS_OVERWRITES = "moduleHasOverwrites";
    public static final String GLOBAL_GROUPING_COLUMN_INFO = "globalGroupingColumnInfo";
    public static final String PRETTIFY_LABELS = "prettifyLabels";
    private final IStoreProvider storeProvider;
    private final RequestContext requestContext;
    private final Map<DeltaAnalysisScope.ScopedTask, DeltaAnalysisScope> deltaAnalysisScopes = new HashMap<DeltaAnalysisScope.ScopedTask, DeltaAnalysisScope>();
    private final Map<String, Object> propertiesBag;
    private final String smartsModuleId;
    private String datasetId;
    private String resourceURI;
    private String masterSmartsModuleUri;
    private ExecutionStatus status = ExecutionStatus.NOT_STARTED;

    public SmartsTaskContext(String smartsModuleId, String datasetId, List<DeltaAnalysisScope> deltaAnalysisScopes, RequestContext requestcontext, IStoreProvider storeProvider) {
        this(smartsModuleId, requestcontext, storeProvider);
        this.datasetId = datasetId;
        if (deltaAnalysisScopes != null) {
            deltaAnalysisScopes.forEach(d -> this.deltaAnalysisScopes.put(d.getScopedTask(), (DeltaAnalysisScope)d));
        }
    }

    public SmartsTaskContext(String smartsModuleId, RequestContext requestcontext, IStoreProvider storeProvider) {
        this.smartsModuleId = smartsModuleId;
        this.storeProvider = storeProvider;
        this.requestContext = requestcontext;
        this.propertiesBag = new ConcurrentHashMap<String, Object>();
    }

    public String getSmartsModuleId() {
        return this.getBatchId();
    }

    public String getDatasetId() {
        return this.getAtomId();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public IStoreProvider getStoreProvider() {
        return this.storeProvider;
    }

    public DeltaAnalysisScope getDeltaAnalysisScope(DeltaAnalysisScope.ScopedTask task) {
        return this.deltaAnalysisScopes.getOrDefault((Object)task, this.deltaAnalysisScopes.get((Object)DeltaAnalysisScope.ScopedTask.ALL));
    }

    public Object getProperty(String name) {
        return this.propertiesBag.get(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesBag.put(name, value);
    }

    public Object removeProperty(String name) {
        return this.propertiesBag.remove(name);
    }

    public String getAtomId() {
        return this.datasetId;
    }

    public String getBatchId() {
        return this.smartsModuleId;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    public String getMasterSmartsModuleURI() {
        return this.masterSmartsModuleUri;
    }

    public void setMasterSmartsModuleURI(String masterResourceURI) {
        this.masterSmartsModuleUri = masterResourceURI;
    }
}

