/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.rest;

import com.ibm.smarts.common.rest.DatasetRestClient;
import com.ibm.smarts.common.rest.ModuleRestClient;
import com.ibm.smarts.common.rest.SmartsModuleRestClient;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.RestClientManager;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;

public class SmartsClientManager
extends RestClientManager {
    public static final String CLIENT_MANAGER_KEY = "com.ibm.smarts.rest.clientManager";
    public static final String SMARTS_BASE_URI = "com.ibm.smarts.rest.baseUri";
    private static final RestClientManager.RestClientType DATASETS_TYPE = new RestClientManager.RestClientType("datasets");
    private static final RestClientManager.RestClientType MODULE_TYPE = new RestClientManager.RestClientType("module");
    private static final RestClientManager.RestClientType SMARTS_MODULE_TYPE = new RestClientManager.RestClientType("smartmodule");

    public static <T> T getClientManager(RequestContext requestContext, Class<T> clazz) {
        Object clientManagerObject;
        ObjectCreator creator = (ObjectCreator)requestContext.getRequestAttribute(CLIENT_MANAGER_KEY);
        if (creator != null) {
            clientManagerObject = creator.create(requestContext);
            if (clientManagerObject == null) {
                throw new InternalException("failed to create client manager from request context ", new Object[]{clazz, creator});
            }
        } else {
            throw new InternalException("missing client manager creator in request context", new Object[]{requestContext});
        }
        return (T)clientManagerObject;
    }

    public SmartsClientManager(RequestContext requestContext) {
        super(requestContext);
    }

    public synchronized DatasetRestClient getDatasetsClient(String baseUri) {
        DatasetRestClient client = (DatasetRestClient)((Object)this.clients.get(DATASETS_TYPE));
        if (client == null) {
            client = new DatasetRestClient(this.restCallContextFactory, this.requestContext, baseUri);
            this.clients.put(DATASETS_TYPE, client);
        }
        return client;
    }

    public synchronized ModuleRestClient getModuleClient(String baseUri) {
        ModuleRestClient client = (ModuleRestClient)((Object)this.clients.get(MODULE_TYPE));
        if (client == null) {
            client = new ModuleRestClient(this.restCallContextFactory, this.requestContext, baseUri);
            this.clients.put(MODULE_TYPE, client);
        }
        return client;
    }

    public synchronized SmartsModuleRestClient getSmartsModuleClient(String baseUri) {
        SmartsModuleRestClient client = (SmartsModuleRestClient)((Object)this.clients.get(SMARTS_MODULE_TYPE));
        if (client == null) {
            client = new SmartsModuleRestClient(this.restCallContextFactory, this.requestContext, baseUri);
            this.clients.put(SMARTS_MODULE_TYPE, client);
        }
        return client;
    }

    public synchronized SmartsModuleRestClient getUserActionClient(String baseUri) {
        return new SmartsModuleRestClient(this.restCallContextFactory, this.requestContext, baseUri);
    }

    public static class SmartsClientManagerCreator
    implements ObjectCreator<SmartsClientManager> {
        public static SmartsClientManagerCreator from(SmartsClientManager clientManager) {
            return new SmartsClientManagerCreator();
        }

        public SmartsClientManager create(RequestContext requestContext) {
            return new SmartsClientManager(requestContext);
        }
    }
}

