/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.internal.ontology.api.function;

import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleMultiMessage;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.function.ClassifyColumnsTaskImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;

public class ClassifyColumnsFunction
extends SmartsModuleFunction<SmartsModuleMultiMessage> {
    public ClassifyColumnsFunction(String taskId, IStoreProvider storeProvider) {
        super(taskId, storeProvider, SmartsModuleMultiMessage.class);
    }

    public SmartsModuleFunctionResult doApply(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMultiMessage message) {
        String moduleId = message.getSmartsModuleId();
        String datasetId = message.getDatasetId();
        SmartsTaskContext context = new SmartsTaskContext(moduleId, datasetId, null, rc, this.storeProvider);
        ClassifyColumnsTaskImpl classifyColumnsTask = new ClassifyColumnsTaskImpl();
        HashMap<String, SmartsModuleMessage> outgoingMessages = new HashMap<String, SmartsModuleMessage>();
        try {
            classifyColumnsTask.execute(context);
        }
        catch (InternalException ex) {
            throw new InternalException((Throwable)ex, String.format("Failed to classify columns for dataset %s caused by: %s", datasetId, ex.getMessage()), new Object[0]);
        }
        outgoingMessages.put("smartsmodule.fanout.column.concept", new SmartsModuleMessage(message.getSmartsModuleId(), message.getDatasetId(), message.getResourceURI()));
        return new SmartsModuleFunctionResult(outgoingMessages);
    }
}

