/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleCodec.class);

    private ModuleCodec() {
    }

    public static InputStream getDecodedInputStream(String value) throws UnsupportedEncodingException {
        InputStream stream = null;
        if (value != null) {
            byte[] valueBytes = value.getBytes("UTF-8");
            if (Base64.isArrayByteBase64((byte[])valueBytes) && null == (stream = ModuleCodec.createZipStream(Base64.decodeBase64((byte[])valueBytes)))) {
                stream = new ByteArrayInputStream(Base64.decodeBase64((byte[])valueBytes));
            }
            if (stream == null) {
                stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
            }
        }
        return stream;
    }

    private static ZipInputStream createZipStream(byte[] decodedBase64) {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(decodedBase64);
        ZipInputStream zipInputStream = new ZipInputStream(byteInputStream);
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                LOGGER.warn("failed to get the ZIP entry, content not in base64 encoded zipped format");
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("failed to close ZIP input stream", (Throwable)e);
                }
                return null;
            }
            return zipInputStream;
        }
        catch (IOException e) {
            LOGGER.error("failed to get the ZIP entry or close the ZIP input stream", (Throwable)e);
            try {
                zipInputStream.close();
            }
            catch (IOException closeException) {
                LOGGER.error("failed to close ZIP input stream", (Throwable)closeException);
            }
            return null;
        }
    }
}

