/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.api;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.ibm.smarts.core.api.AlwaysAllowedPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AlwaysAllowedPermissions.class, name="alwaysallowedpermissions")})
public interface IAssetPermissions {
    public CompletableFuture<PermissionResult> hasPermission(String var1);

    public CompletableFuture<List<PermissionResult>> hasPermission(List<String> var1);

    default public CompletableFuture<List<String>> filterAllowed(List<String> names) {
        CompletableFuture<List<PermissionResult>> cf = this.hasPermission(names);
        CompletionStage ret = cf.thenApply(list -> {
            ArrayList<String> allowed = new ArrayList<String>();
            for (PermissionResult pr : list) {
                if (!pr.granted) continue;
                allowed.add(pr.name);
            }
            return allowed;
        });
        return ret;
    }

    public static class PermissionResult {
        public final boolean granted;
        public final String name;

        public PermissionResult(boolean granted, String name) {
            this.granted = granted;
            this.name = name;
        }
    }
}

