/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.util.Timer;
import com.ibm.smarts.core.util.Tuple2;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMetrics<T extends AbstractMetrics<?>>
extends Timer {
    public abstract boolean isTouched();

    public abstract long firstTouchNanos();

    public abstract long lastTouchNanos();

    public Tuple2<Long, Long> activeSpanNanos() {
        long first = this.firstTouchNanos();
        long last = this.lastTouchNanos();
        Tuple2<Long, Long> ret = first == 0L || first != 0L && last < first ? new Tuple2<Long, Long>(0L, 0L) : new Tuple2<Long, Long>(first, last);
        return ret;
    }

    public long activeDurationNanos() {
        Tuple2<Long, Long> span = this.activeSpanNanos();
        long duration = (Long)span._2 - (Long)span._1;
        return duration;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean pretty) {
        return this.toString(pretty, 0);
    }

    protected abstract String toString(boolean var1, int var2);

    protected static String linePrefix(boolean pretty, int indent) {
        StringBuilder sb = new StringBuilder();
        if (!pretty) {
            sb.append(" ");
        } else {
            sb.append("\n");
            for (int i = 0; i < indent; ++i) {
                sb.append("  ");
            }
        }
        String ret = sb.toString();
        return ret;
    }

    public static <T extends AbstractMetrics<?>> boolean isTouched(Collection<T> metrics) {
        for (AbstractMetrics m : metrics) {
            if (!m.isTouched()) continue;
            return true;
        }
        return false;
    }

    public static <T extends AbstractMetrics<?>> boolean isTouched(T ... metrics) {
        List<T> list = Arrays.asList(metrics);
        return AbstractMetrics.isTouched(list);
    }

    public static <T extends AbstractMetrics<?>> int countTouched(Collection<T> metrics) {
        int ret = 0;
        for (AbstractMetrics m : metrics) {
            if (!m.isTouched()) continue;
            ++ret;
        }
        return ret;
    }

    public static <T extends AbstractMetrics<?>> int countTouched(T ... metrics) {
        List<T> list = Arrays.asList(metrics);
        return AbstractMetrics.countTouched(list);
    }

    public static <T extends AbstractMetrics<?>> long lastTouchNanos(Collection<T> metrics) {
        long max = 0L;
        for (AbstractMetrics m : metrics) {
            long lt = m.lastTouchNanos();
            if (lt == 0L || lt <= max) continue;
            max = lt;
        }
        return max;
    }

    public static <T extends AbstractMetrics<?>> long lastTouchNanos(T ... metrics) {
        List<T> list = Arrays.asList(metrics);
        return AbstractMetrics.lastTouchNanos(list);
    }

    public static <T extends AbstractMetrics<?>> long firstTouchNanos(Collection<T> metrics) {
        long max = Long.MAX_VALUE;
        for (AbstractMetrics m : metrics) {
            long lt = m.firstTouchNanos();
            if (lt == 0L || lt >= max) continue;
            max = lt;
        }
        if (max == Long.MAX_VALUE) {
            max = 0L;
        }
        return max;
    }

    public static <T extends AbstractMetrics<?>> long firstTouchNanos(T ... metrics) {
        List<T> list = Arrays.asList(metrics);
        return AbstractMetrics.firstTouchNanos(list);
    }

    protected static long max(long ... values) {
        long ret = Long.MIN_VALUE;
        for (long value : values) {
            if (value <= ret) continue;
            ret = value;
        }
        return ret;
    }

    protected static long minNonZero(long ... values) {
        long ret = Long.MAX_VALUE;
        for (long value : values) {
            if (value == 0L || value >= ret) continue;
            ret = value;
        }
        return ret;
    }

    protected static <T> String[] sortedStrings(Collection<T> c) {
        Object[] oArr = c.toArray();
        return AbstractMetrics.sortedStrings(oArr);
    }

    protected static <T> String[] sortedStrings(T[] oArr) {
        Object[] sArr = new String[oArr.length];
        for (int i = 0; i < oArr.length; ++i) {
            T o = oArr[i];
            sArr[i] = o == null ? null : o.toString();
        }
        Arrays.sort(sArr);
        return sArr;
    }
}

