/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.ibm.smarts.core.exceptions.json.JsonSerializeException;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class JsonParserDelegate {
    private final ObjectMapper jacksonOM;

    public JsonParserDelegate(ObjectMapper mapper) {
        this.jacksonOM = mapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.jacksonOM;
    }

    public String toJson(Object obj) {
        String ret;
        try {
            ret = this.getObjectMapper().writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new JsonSerializeException((Throwable)e, "Failed to generate JSON", obj);
        }
        return ret;
    }

    public <T> T fromJson(String json, Class<T> klass) {
        Object ret;
        try {
            ret = this.getObjectMapper().readValue(json, klass);
            if (ret instanceof SmartsModule) {
                SmartsModuleUtil.migrate((SmartsModule)((SmartsModule)ret));
            }
        }
        catch (IOException e) {
            throw new JsonSerializeException((Throwable)e, "Failed to deserialize JSON", json, klass);
        }
        return (T)ret;
    }

    public JsonNode parseJson(String json) {
        JsonNode ret;
        try {
            ret = this.getObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON: " + json, e);
        }
        return ret;
    }

    public <T> T parseJson(JsonNode jn, Class<T> klass) {
        Object ret;
        try {
            ret = this.getObjectMapper().treeToValue((TreeNode)jn, klass);
            if (ret instanceof SmartsModule) {
                SmartsModuleUtil.migrate((SmartsModule)((SmartsModule)ret));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert JsonNode: " + jn + " to class " + klass.getCanonicalName(), e);
        }
        return (T)ret;
    }

    public <T> List<T> parseJsonAsList(String jString, Class<T> klass) {
        List ret;
        try {
            CollectionType type = this.getObjectMapper().getTypeFactory().constructCollectionType(List.class, klass);
            ret = (List)this.getObjectMapper().readValue(jString, (JavaType)type);
            if (!ret.isEmpty() && ret.get(0) instanceof SmartsModule) {
                SmartsModuleUtil.migrate((Collection)ret);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert JsonNode: " + jString + " to class " + klass.getCanonicalName(), e);
        }
        return ret;
    }

    public JsonNode getJsonFromStream(InputStream input) throws IOException {
        byte[] json = IOUtils.toByteArray((InputStream)input);
        return this.parseJson(new String(json, Charset.forName("UTF-8")));
    }

    public String getJsonStringFromStream(InputStream input) throws IOException {
        byte[] json = IOUtils.toByteArray((InputStream)input);
        return new String(json, Charset.forName("UTF-8"));
    }

    public JsonNode toJsonNode(Object obj) {
        try {
            return this.getObjectMapper().valueToTree(obj);
        }
        catch (Throwable e) {
            throw new JsonSerializeException(e, "Failed to generate JsonNode", obj);
        }
    }
}

