/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.api.IAssetPermissions;
import com.ibm.smarts.core.api.ICredentials;
import com.ibm.smarts.core.i18n.NLS;
import com.ibm.smarts.core.util.ToString;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class Request {
    public final UUID uuid;
    public final Locale locale;
    public final Locale productLocale;
    public ICredentials credentials;
    public final IAssetPermissions permissions;
    public final boolean isTracing;
    public static final String ATTR_HTTP_HEADERS = "*HTTP-Headers*";
    public final Map<String, Object> attributes = new HashMap<String, Object>();

    public Request(Request request) {
        this.uuid = request.uuid;
        this.locale = request.locale;
        this.productLocale = request.productLocale;
        this.credentials = request.credentials;
        this.permissions = request.permissions;
        this.isTracing = request.isTracing;
        this.attributes.putAll(request.attributes);
    }

    public Request(Locale locale, Locale productLocale) {
        this(locale, productLocale, null, null, false);
    }

    public Request(Locale locale, Locale productLocale, boolean isTracing) {
        this(locale, productLocale, null, null, isTracing);
    }

    public Request(Locale locale, Locale productLocale, ICredentials credentials) {
        this(locale, productLocale, credentials, null, false);
    }

    public Request(Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions) {
        this(locale, productLocale, credentials, permissions, false);
    }

    public Request(Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions, boolean isTracing) {
        this(UUID.randomUUID(), locale, productLocale, credentials, permissions, isTracing);
    }

    public Request(UUID uuid, Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions, boolean isTracing) {
        this.uuid = uuid;
        this.locale = locale;
        this.productLocale = productLocale;
        this.credentials = credentials;
        this.permissions = permissions;
        this.isTracing = isTracing;
    }

    public String toString() {
        return ToString.with(this).field("uuid", this.uuid).field("locale", this.locale).field("productLocale", this.productLocale).field("isTracing", this.isTracing).field("attributes", this.attributes).field("credentials", this.credentials).field("permissions", this.permissions).get();
    }

    public <T extends NLS> T messages(Class<?> clazz) {
        Object ret = NLS.get(clazz, this.locale.toString());
        return ret;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setHttpHeaders(Map<String, List<String>> headers) {
        this.setAttribute(ATTR_HTTP_HEADERS, headers);
    }

    public Map<String, List<String>> getHttpHeaders() {
        Object value = this.getAttribute(ATTR_HTTP_HEADERS);
        HashMap<String, List<String>> ret = value == null ? new HashMap<String, List<String>>() : (HashMap<String, List<String>>)value;
        return ret;
    }
}

