/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.langware.annotator.Copyright;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.text.AnnotationFS;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LrwCasCopier {
    private final CAS _sourceCas;
    private final CAS _destCas;
    private final LowLevelCAS _llSourceCas;
    private final LowLevelCAS _llDestCas;
    private final LowLevelTypeSystem _llSourceTypeSystem;
    private final LowLevelTypeSystem _llDestTypeSystem;
    private final Feature _destSofaFeature;
    private final int _intTypeCode;
    private final int _stringTypeCode;
    private final int _floatTypeCode;
    private final int _byteTypeCode;
    private final int _booleanTypeCode;
    private final int _shortTypeCode;
    private final int _longTypeCode;
    private final int _doubleTypeCode;
    private final Map<String, Integer> _stringPool = new HashMap<String, Integer>();
    private final Map<FeatureStructure, FeatureStructure> _copiedFS = new HashMap<FeatureStructure, FeatureStructure>();
    private static final Method GET_CELLS_USED;

    public static Properties getPerformancePropertiesForCopy(CAS cAS) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Properties properties = UIMAFramework.getDefaultPerformanceTuningProperties();
        int n = LrwCasCopier.getHeapSize(cAS);
        if (n > 0) {
            properties.setProperty("cas_initial_heap_size", Integer.toString(n));
        }
        return properties;
    }

    private static int getHeapSize(CAS cAS) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!(cAS instanceof CASImpl) || GET_CELLS_USED == null) {
            return -1;
        }
        Heap heap = ((CASImpl)cAS).getHeap();
        Object object = GET_CELLS_USED.invoke((Object)heap, (Object[])null);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public static void copyFullCas(CAS cAS, CAS cAS2, boolean bl) {
        LrwCasCopier lrwCasCopier = new LrwCasCopier(cAS, cAS2);
        lrwCasCopier.copyFullCas(bl, null);
    }

    public static void copyAnnotationsWithDiscard(CAS cAS, CAS cAS2, String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        LowLevelTypeSystem lowLevelTypeSystem = cAS.getLowLevelCAS().ll_getTypeSystem();
        int n = 0;
        for (String string : stringArray) {
            nArray[n++] = lowLevelTypeSystem.ll_getCodeForTypeName(string);
        }
        LrwCasCopier lrwCasCopier = new LrwCasCopier(cAS, cAS2);
        super.copyFullCas(false, nArray);
    }

    public static void copyAnnotationsWithDiscard(CAS cAS, CAS cAS2, int[] nArray) {
        LrwCasCopier lrwCasCopier = new LrwCasCopier(cAS, cAS2);
        lrwCasCopier.copyFullCas(false, nArray);
    }

    public static void copyAnnotationType(CAS cAS, CAS cAS2, int n) {
        LrwCasCopier lrwCasCopier = new LrwCasCopier(cAS, cAS2);
        lrwCasCopier.copyAnnotationType(n);
    }

    public LrwCasCopier(CAS cAS, CAS cAS2) {
        this._sourceCas = cAS;
        this._destCas = cAS2;
        this._llDestCas = cAS2.getLowLevelCAS();
        this._llSourceCas = cAS.getLowLevelCAS();
        this._llSourceTypeSystem = this._llSourceCas.ll_getTypeSystem();
        this._llDestTypeSystem = this._llDestCas.ll_getTypeSystem();
        this._destSofaFeature = cAS2.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
        this._intTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Integer");
        this._stringTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.String");
        this._floatTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Float");
        this._byteTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Byte");
        this._booleanTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Boolean");
        this._shortTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Short");
        this._longTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Long");
        this._doubleTypeCode = this._llSourceTypeSystem.ll_getCodeForTypeName("uima.cas.Double");
    }

    private void copyAnnotationType(int n) {
        LowLevelIndex lowLevelIndex = this._llSourceCas.ll_getIndexRepository().ll_getIndex("AnnotationIndex", n);
        LowLevelIterator lowLevelIterator = lowLevelIndex.ll_iterator();
        while (lowLevelIterator.isValid()) {
            int n2 = lowLevelIterator.ll_get();
            FeatureStructure featureStructure = this._llSourceCas.ll_getFSForRef(n2);
            FeatureStructure featureStructure2 = this.copyFS(featureStructure);
            this._destCas.addFsToIndexes(featureStructure2);
            lowLevelIterator.moveToNext();
        }
    }

    private void copyFullCas(boolean bl, int[] nArray) {
        FSIterator fSIterator = this._sourceCas.getSofaIterator();
        while (fSIterator.hasNext()) {
            SofaFS sofaFS = (SofaFS)fSIterator.next();
            CAS cAS = this._sourceCas.getView(sofaFS);
            this.copyCasView(cAS, bl, nArray);
        }
    }

    private void copyCasView(CAS cAS, boolean bl, int[] nArray) {
        CAS cAS2 = LrwCasCopier.findView(this._destCas, cAS.getViewName());
        if (bl) {
            this.copySofa(cAS, cAS2);
        }
        HashSet<FeatureStructure> hashSet = new HashSet<FeatureStructure>();
        Iterator iterator = cAS.getIndexRepository().getIndexes();
        while (iterator.hasNext()) {
            this.copyIndex((FSIndex<FeatureStructure>)((FSIndex)iterator.next()), cAS2, nArray, hashSet);
        }
    }

    private void copyIndex(FSIndex<FeatureStructure> fSIndex, CAS cAS, int[] nArray, Set<FeatureStructure> set) {
        LowLevelTypeSystem lowLevelTypeSystem = this._llSourceCas.ll_getTypeSystem();
        block0: for (FeatureStructure featureStructure : fSIndex) {
            Object object;
            if (set.contains(featureStructure)) continue;
            if (nArray != null && nArray.length > 0) {
                int n = ((TypeImpl)featureStructure.getType()).getCode();
                object = nArray;
                int n2 = ((int[])object).length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = object[i];
                    if (n3 != 0 && (n3 == n || lowLevelTypeSystem.ll_subsumes(n3, n))) continue block0;
                }
            }
            FeatureStructure featureStructure2 = this.copyFS(featureStructure);
            if (featureStructure instanceof AnnotationFS && (object = (Object)((AnnotationFS)featureStructure2).getFeatureValue(this._destSofaFeature)) == null) {
                featureStructure2.setFeatureValue(this._destSofaFeature, (FeatureStructure)cAS.getSofa());
            }
            if (!LrwCasCopier.isDocumentAnnotation(featureStructure2)) {
                cAS.addFsToIndexes(featureStructure2);
            }
            set.add(featureStructure);
        }
    }

    private void copySofa(CAS cAS, CAS cAS2) {
        String string = cAS.getSofa().getSofaMime();
        if (cAS.getDocumentText() != null) {
            cAS2.setSofaDataString(cAS.getDocumentText(), string);
        } else if (cAS.getSofaDataURI() != null) {
            cAS2.setSofaDataURI(cAS.getSofaDataURI(), string);
        } else if (cAS.getSofaDataArray() != null) {
            cAS2.setSofaDataArray(this.copyFS(cAS.getSofaDataArray()), string);
        }
    }

    public FeatureStructure copyFS(FeatureStructure featureStructure) {
        FeatureStructure featureStructure2 = this._copiedFS.get(featureStructure);
        if (featureStructure2 != null) {
            return featureStructure2;
        }
        if (featureStructure instanceof SofaFS) {
            String string = ((SofaFS)featureStructure).getSofaID();
            return LrwCasCopier.findView(this._destCas, string).getSofa();
        }
        Type type = featureStructure.getType();
        if (LrwCasCopier.isDocumentAnnotation(featureStructure)) {
            String string = ((AnnotationFS)featureStructure).getView().getViewName();
            CAS cAS = this._destCas.getView(string);
            AnnotationFS annotationFS = cAS.getDocumentAnnotation();
            if (annotationFS != null) {
                this.copyFeatures(featureStructure, type, (FeatureStructure)annotationFS);
            }
            return annotationFS;
        }
        if (type.isArray()) {
            featureStructure2 = this.copyArray(featureStructure);
            this._copiedFS.put(featureStructure, featureStructure2);
            return featureStructure2;
        }
        Type type2 = this._destCas.getTypeSystem().getType(type.getName());
        if (type2 == null) {
            throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{type.getName()});
        }
        int n = this._llDestCas.ll_getTypeSystem().ll_getCodeForType(type2);
        int n2 = this._llDestCas.ll_createFS(n);
        FeatureStructure featureStructure3 = this._llDestCas.ll_getFSForRef(n2);
        this._copiedFS.put(featureStructure, featureStructure3);
        this.copyFeatures(featureStructure, type, featureStructure3);
        return featureStructure3;
    }

    private void copyFeatures(FeatureStructure featureStructure, Type type, FeatureStructure featureStructure2) {
        Type type2 = featureStructure2.getType();
        for (Feature feature : type.getFeatures()) {
            Feature feature2;
            if (type2 == featureStructure.getType()) {
                feature2 = feature;
            } else {
                feature2 = type2.getFeatureByBaseName(feature.getShortName());
                if (feature2 == null) {
                    throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{feature.getName()});
                }
            }
            Type type3 = feature.getRange();
            if (type3.isPrimitive()) {
                this.copyPrimitiveFeature(featureStructure2, feature2, featureStructure, feature, type3);
                continue;
            }
            FeatureStructure featureStructure3 = featureStructure.getFeatureValue(feature);
            if (featureStructure3 == null) continue;
            FeatureStructure featureStructure4 = this.copyFS(featureStructure3);
            featureStructure2.setFeatureValue(feature2, featureStructure4);
        }
    }

    private void copyPrimitiveFeature(FeatureStructure featureStructure, Feature feature, FeatureStructure featureStructure2, Feature feature2, Type type) {
        int n = this._llSourceCas.ll_getFSRef(featureStructure2);
        int n2 = this._llDestCas.ll_getFSRef(featureStructure);
        int n3 = this._llSourceTypeSystem.ll_getCodeForType(type);
        int n4 = this._llSourceTypeSystem.ll_getCodeForFeature(feature2);
        int n5 = this._llDestTypeSystem.ll_getCodeForFeature(feature);
        if (n3 == this._intTypeCode) {
            int n6 = this._llSourceCas.ll_getIntValue(n, n4);
            this._llDestCas.ll_setIntValue(n2, n5, n6);
        } else if (n3 == this._booleanTypeCode) {
            boolean bl = this._llSourceCas.ll_getBooleanValue(n, n4);
            this._llDestCas.ll_setBooleanValue(n2, n5, bl);
        } else if (this._stringTypeCode == n3 || this._llSourceTypeSystem.ll_subsumes(this._stringTypeCode, n3)) {
            String string = this._llSourceCas.ll_getStringValue(n, n4);
            Integer n7 = this._stringPool.get(string);
            if (n7 != null) {
                this._llDestCas.ll_setIntValue(n2, n5, n7.intValue());
            } else {
                this._llDestCas.ll_setStringValue(n2, n5, string);
                n7 = this._llDestCas.ll_getIntValue(n2, n5);
                this._stringPool.put(string, n7);
            }
        } else if (n3 == this._byteTypeCode) {
            byte by = this._llSourceCas.ll_getByteValue(n, n4);
            this._llDestCas.ll_setByteValue(n2, n5, by);
        } else if (n3 == this._shortTypeCode) {
            short s = this._llSourceCas.ll_getShortValue(n, n4);
            this._llDestCas.ll_setShortValue(n2, n5, s);
        } else if (n3 == this._longTypeCode) {
            long l = this._llSourceCas.ll_getLongValue(n, n4);
            this._llDestCas.ll_setLongValue(n2, n5, l);
        } else if (n3 == this._floatTypeCode) {
            float f = this._llSourceCas.ll_getFloatValue(n, n4);
            this._llDestCas.ll_setFloatValue(n2, n5, f);
        } else if (n3 == this._doubleTypeCode) {
            double d = this._llSourceCas.ll_getDoubleValue(n, n4);
            this._llDestCas.ll_setDoubleValue(n2, n5, d);
        } else {
            featureStructure.setFeatureValueFromString(feature, featureStructure2.getFeatureValueAsString(feature2));
        }
    }

    private FeatureStructure copyArray(FeatureStructure featureStructure) {
        if (featureStructure instanceof ArrayFS) {
            ArrayFS arrayFS = (ArrayFS)featureStructure;
            int n = arrayFS.size();
            ArrayFS arrayFS2 = this._destCas.createArrayFS(n);
            for (int i = 0; i < n; ++i) {
                FeatureStructure featureStructure2 = arrayFS.get(i);
                if (featureStructure2 == null) continue;
                FeatureStructure featureStructure3 = this.copyFS(featureStructure2);
                arrayFS2.set(i, featureStructure3);
            }
            return arrayFS2;
        }
        if (featureStructure instanceof StringArrayFS) {
            StringArrayFS stringArrayFS = (StringArrayFS)featureStructure;
            int n = stringArrayFS.size();
            StringArrayFS stringArrayFS2 = this._destCas.createStringArrayFS(n);
            for (int i = 0; i < n; ++i) {
                stringArrayFS2.set(i, stringArrayFS.get(i));
            }
            return stringArrayFS2;
        }
        if (featureStructure instanceof IntArrayFS) {
            IntArrayFS intArrayFS = (IntArrayFS)featureStructure;
            int n = intArrayFS.size();
            IntArrayFS intArrayFS2 = this._destCas.createIntArrayFS(n);
            for (int i = 0; i < n; ++i) {
                intArrayFS2.set(i, intArrayFS.get(i));
            }
            return intArrayFS2;
        }
        if (featureStructure instanceof BooleanArrayFS) {
            BooleanArrayFS booleanArrayFS = (BooleanArrayFS)featureStructure;
            int n = booleanArrayFS.size();
            BooleanArrayFS booleanArrayFS2 = this._destCas.createBooleanArrayFS(n);
            for (int i = 0; i < n; ++i) {
                booleanArrayFS2.set(i, booleanArrayFS.get(i));
            }
            return booleanArrayFS2;
        }
        if (featureStructure instanceof ByteArrayFS) {
            ByteArrayFS byteArrayFS = (ByteArrayFS)featureStructure;
            int n = byteArrayFS.size();
            ByteArrayFS byteArrayFS2 = this._destCas.createByteArrayFS(n);
            for (int i = 0; i < n; ++i) {
                byteArrayFS2.set(i, byteArrayFS.get(i));
            }
            return byteArrayFS2;
        }
        if (featureStructure instanceof ShortArrayFS) {
            ShortArrayFS shortArrayFS = (ShortArrayFS)featureStructure;
            int n = shortArrayFS.size();
            ShortArrayFS shortArrayFS2 = this._destCas.createShortArrayFS(n);
            for (int i = 0; i < n; ++i) {
                shortArrayFS2.set(i, shortArrayFS.get(i));
            }
            return shortArrayFS2;
        }
        if (featureStructure instanceof LongArrayFS) {
            LongArrayFS longArrayFS = (LongArrayFS)featureStructure;
            int n = longArrayFS.size();
            LongArrayFS longArrayFS2 = this._destCas.createLongArrayFS(n);
            for (int i = 0; i < n; ++i) {
                longArrayFS2.set(i, longArrayFS.get(i));
            }
            return longArrayFS2;
        }
        if (featureStructure instanceof FloatArrayFS) {
            FloatArrayFS floatArrayFS = (FloatArrayFS)featureStructure;
            int n = floatArrayFS.size();
            FloatArrayFS floatArrayFS2 = this._destCas.createFloatArrayFS(n);
            for (int i = 0; i < n; ++i) {
                floatArrayFS2.set(i, floatArrayFS.get(i));
            }
            return floatArrayFS2;
        }
        if (featureStructure instanceof DoubleArrayFS) {
            DoubleArrayFS doubleArrayFS = (DoubleArrayFS)featureStructure;
            int n = doubleArrayFS.size();
            DoubleArrayFS doubleArrayFS2 = this._destCas.createDoubleArrayFS(n);
            for (int i = 0; i < n; ++i) {
                doubleArrayFS2.set(i, doubleArrayFS.get(i));
            }
            return doubleArrayFS2;
        }
        assert (false);
        return null;
    }

    private static CAS findView(CAS cAS, String string) {
        try {
            return cAS.getView(string);
        }
        catch (CASRuntimeException cASRuntimeException) {
            return cAS.createView(string);
        }
    }

    private static boolean isDocumentAnnotation(FeatureStructure featureStructure) {
        return featureStructure instanceof AnnotationFS && featureStructure.equals(((AnnotationFS)featureStructure).getView().getDocumentAnnotation());
    }

    static {
        Method method = null;
        try {
            method = Heap.class.getDeclaredMethod("getCellsUsed", null);
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_CELLS_USED = method;
    }
}

