/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.ConditionalFlowStage;
import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class SwitchFlowStage
implements IFlowStage {
    private final List<ConditionalFlowStage> _testStages;
    private final ConditionalFlowStage _elseStage;
    private int _currStageIndex;
    private boolean _doneTest;

    public SwitchFlowStage(List<ConditionalFlowStage> list, ConditionalFlowStage conditionalFlowStage) {
        this._testStages = list;
        this._elseStage = conditionalFlowStage;
    }

    @Override
    public void reset() {
        this._currStageIndex = 0;
        this._doneTest = false;
        for (ConditionalFlowStage conditionalFlowStage : this._testStages) {
            conditionalFlowStage.reset();
        }
        this._elseStage.reset();
    }

    public List<ConditionalFlowStage> getTestStages() {
        return this._testStages;
    }

    public ConditionalFlowStage getElseStage() {
        return this._elseStage;
    }

    @Override
    public boolean hasNext(CAS cAS) throws AnalysisEngineProcessException {
        while (this._currStageIndex < this._testStages.size()) {
            IFlowStage iFlowStage = this._testStages.get(this._currStageIndex);
            if (iFlowStage.hasNext(cAS)) {
                this._doneTest = true;
                return true;
            }
            ++this._currStageIndex;
        }
        if (!this._doneTest) {
            return this._elseStage.hasNext(cAS);
        }
        return false;
    }

    @Override
    public String next() throws AnalysisEngineProcessException {
        if (this._currStageIndex >= this._testStages.size()) {
            return this._elseStage.next();
        }
        IFlowStage iFlowStage = this._testStages.get(this._currStageIndex);
        return iFlowStage.next();
    }

    @Override
    public void describe(int n, Logger logger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(Messages.getMessage("SwitchFlowStage.name"));
        logger.log(Level.CONFIG, stringBuilder.toString());
        for (ConditionalFlowStage conditionalFlowStage : this._testStages) {
            conditionalFlowStage.describe(n + 1, logger);
        }
        this._elseStage.describe(n + 1, logger);
    }
}

