/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.generic;

import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.TypeManager;
import com.ibm.langware.annotator.Copyright;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.cas.impl.LowLevelCAS;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
class FSEntry {
    private final String _typeName;
    private final int _fs;
    private Map<String, Collection<Integer>> _arrayValues;

    FSEntry(String string, int n) {
        this._typeName = string;
        this._fs = n;
    }

    String getTypeName() {
        return this._typeName;
    }

    int getFS() {
        return this._fs;
    }

    void addPendingArrayValue(String string, int n) {
        Collection<Integer> collection;
        if (this._arrayValues == null) {
            this._arrayValues = new TreeMap<String, Collection<Integer>>();
        }
        if ((collection = this._arrayValues.get(string)) == null) {
            collection = new ArrayList<Integer>();
            this._arrayValues.put(string, collection);
        }
        collection.add(n);
    }

    void addArrays(TypeManager typeManager, LowLevelCAS lowLevelCAS, boolean bl) throws AnnotateException {
        if (this._arrayValues == null) {
            return;
        }
        Iterator<Map.Entry<String, Collection<Integer>>> iterator = this._arrayValues.entrySet().iterator();
        while (iterator.hasNext()) {
            this.addArray(typeManager, lowLevelCAS, iterator.next(), bl);
        }
    }

    private void addArray(TypeManager typeManager, LowLevelCAS lowLevelCAS, Map.Entry<String, Collection<Integer>> entry, boolean bl) throws AnnotateException {
        int n;
        String string = entry.getKey();
        Collection<Integer> collection = entry.getValue();
        int n2 = lowLevelCAS.ll_createArray(typeManager.getFsArrayTypeCode(), collection.size(), bl);
        Iterator<Integer> iterator = collection.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            n = iterator.next();
            lowLevelCAS.ll_setRefArrayValue(n2, n3, n, bl);
            ++n3;
        }
        n = typeManager.getFeatureCode(this, string);
        lowLevelCAS.ll_setRefValue(this._fs, n, n2, bl);
    }
}

