/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.pos_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.uima_annotator.util.ConfigurationParameterUtil;
import com.ibm.dltj.util.PooledList;
import com.ibm.langware.annotator.Copyright;
import java.net.URL;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceConfigurationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
abstract class Method<T> {
    protected final Language _language;
    private TagHandler.TagSelectionPolicy _postTagHandling = TagHandler.TagSelectionPolicy.FIRST;
    private TokenInfo.RetainmentPolicy _postLemmaEntryHandling = TokenInfo.RetainmentPolicy.BEST_ONLY;
    private int _maxCharNumPerSentence = 1000;
    protected TagHandler<T> _handler;
    private static final int DEFAULT_MAX_CHAR_NUM_PER_SENTENCE = 1000;

    protected Method(UimaContext uimaContext, String string, URL uRL) throws ResourceConfigurationException {
        String string2;
        assert (uimaContext != null);
        assert (string != null);
        assert (uRL != null);
        this._language = new Language(string);
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(uimaContext);
        String string3 = configurationParameterUtil.getString(this._language, "PostTagHandling", null);
        if (string3 != null) {
            try {
                this._postTagHandling = TagHandler.TagSelectionPolicy.valueOf((String)string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ResourceConfigurationException("resource_data_not_valid", new Object[]{string3, "PostTagHandling"});
            }
        }
        if ((string2 = configurationParameterUtil.getString(this._language, "PostLemmaEntryHandling", null)) != null) {
            try {
                this._postLemmaEntryHandling = TokenInfo.RetainmentPolicy.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ResourceConfigurationException("resource_data_not_valid", new Object[]{string2, "PostLemmaEntryHandling"});
            }
        }
        this._maxCharNumPerSentence = configurationParameterUtil.getInteger(this._language, "MaxCharNumPerSentence", 1000);
        if (this._maxCharNumPerSentence < 0) {
            throw new ResourceConfigurationException("resource_data_not_valid", new Object[]{this._maxCharNumPerSentence, "MaxCharNumPerSentence"});
        }
        assert (this._language != null);
        assert (this._postTagHandling != null);
        assert (this._postLemmaEntryHandling != null);
        assert (this._maxCharNumPerSentence >= 0);
    }

    Language language() {
        return this._language;
    }

    abstract void invoke(CAS var1, int var2, int var3, PooledList<TokenInfo> var4, PartOfSpeechAnnotationCreator var5) throws DLTException;

    protected final void annotate(TokenInfo tokenInfo, T object, PartOfSpeechAnnotationCreator partOfSpeechAnnotationCreator) {
        if (object == null) {
            partOfSpeechAnnotationCreator.annotateLemmaEntriesAndPOSTag(tokenInfo.addr, tokenInfo, null);
            return;
        }
        if (this._handler.isAmbiguous(object)) {
            object = this._postTagHandling.apply(this._handler, object);
        }
        if (tokenInfo.size() > 1) {
            tokenInfo.moveToStart(this.seek(tokenInfo, object));
            this._postLemmaEntryHandling.apply(tokenInfo);
        }
        partOfSpeechAnnotationCreator.annotateLemmaEntriesAndPOSTag(tokenInfo.addr, tokenInfo, object.toString());
    }

    protected int seek(TokenInfo tokenInfo, T t) {
        return -1;
    }

    int capacity() {
        return this._maxCharNumPerSentence;
    }
}

