/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.pos_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.pos_analysis.Method;
import com.ibm.dltj.uima_annotator.pos_analysis.MethodCRF;
import com.ibm.dltj.uima_annotator.pos_analysis.MethodMappingBased;
import com.ibm.dltj.uima_annotator.pos_analysis.MethodRuleBased;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.uima_annotator.util.ConfigurationParameterUtil;
import com.ibm.dltj.util.FileUtils;
import com.ibm.dltj.util.ListBase;
import com.ibm.dltj.util.PooledItemAllocator;
import com.ibm.dltj.util.PooledList;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class PartOfSpeechAnalyzer {
    private CAS _cas;
    private Method<?> _method;
    private final Map<String, Reference<Method<?>>> _methods = new HashMap();
    private final PooledList<TokenInfo> _tokens = new PooledList((ListBase)new TokenInfo());
    private int _beginIndex;
    private int _endIndex;

    public Method<?> open(CAS cAS, UimaContext uimaContext) throws AnalysisEngineProcessException {
        this._cas = cAS;
        this._tokens.clear();
        this._beginIndex = 0;
        this._endIndex = 0;
        try {
            this._method = this.getMethod(uimaContext, cAS.getDocumentLanguage());
            return this._method;
        }
        catch (IOException iOException) {
            throw new AnalysisEngineProcessException((Throwable)iOException);
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
        catch (ResourceConfigurationException resourceConfigurationException) {
            throw new AnalysisEngineProcessException((Throwable)resourceConfigurationException);
        }
    }

    public void close() {
        this._cas = null;
        this._tokens.dispose();
        this._method = null;
    }

    protected Method<?> getMethod(UimaContext uimaContext, String string) throws IOException, DLTException, ResourceConfigurationException {
        Reference<Method<?>> reference;
        String string2 = Language.normalize((String)string);
        if (this._methods.containsKey(string2)) {
            reference = this._methods.get(string2);
            if (reference == null) {
                return null;
            }
            Method method = (Method)reference.get();
            if (method != null) {
                return method;
            }
        }
        if ((reference = this.createMethod(uimaContext, string)) == null) {
            this._methods.put(string2, null);
            return null;
        }
        this._methods.put(string2, new SoftReference<Object>(reference));
        return reference;
    }

    protected Method<?> createMethod(UimaContext uimaContext, String string) throws IOException, DLTException, ResourceConfigurationException {
        Logger logger = uimaContext.getLogger();
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(uimaContext);
        String string2 = configurationParameterUtil.getString(string, "PartOfSpeechDict");
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Language language = new Language(string);
        URI uRI = configurationParameterUtil.getResourceURI("Resources", language, "PartOfSpeechDict");
        if (uRI == null) {
            throw new IOException(Messages.getFormattedMessage("PartOfSpeechAnalyzer.Error_dictionary_not_found", string, configurationParameterUtil.getString(language, "PartOfSpeechDict", null)));
        }
        URL uRL = uRI.toURL();
        File file = new File(uRI);
        if (file.exists()) {
            String string3 = null;
            if (FileUtils.isZip((URL)uRL)) {
                try {
                    JarFile jarFile = new JarFile(file);
                    Manifest manifest = jarFile.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    string3 = attributes.getValue("LanguageWare-POSTaggerDictionary-Algorithm");
                }
                catch (IOException iOException) {}
            } else {
                string3 = "CRF";
            }
            if ("UNSUPERVISED_RULE_BASED".equals(string3)) {
                return new MethodRuleBased(uimaContext, string, uRL);
            }
            if ("MAPPING_BASED".equals(string3)) {
                return new MethodMappingBased(uimaContext, string, uRL);
            }
            if ("CRF".equals(string3)) {
                return new MethodCRF(uimaContext, string, uRL);
            }
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, Messages.getFormattedMessage("PartOfSpeechAnalyzer.Error_invalid_dictionary", string, uRI));
        }
        return null;
    }

    public boolean addToken(TokenInfo tokenInfo) {
        if (this._method == null || !tokenInfo.type.isTagged) {
            return false;
        }
        assert (tokenInfo == this._tokens.getCurItem());
        if (this.hasRemaining(tokenInfo)) {
            this._tokens.commitItem();
            return true;
        }
        return false;
    }

    private boolean hasRemaining(TokenInfo tokenInfo) {
        if (this._tokens.isEmpty()) {
            this._beginIndex = tokenInfo.begin;
            this._endIndex = tokenInfo.end;
            return true;
        }
        int n = Math.min(this._beginIndex, tokenInfo.begin);
        int n2 = Math.max(this._endIndex, tokenInfo.end);
        int n3 = n2 - n;
        if (n3 <= this._method.capacity()) {
            this._beginIndex = n;
            this._endIndex = n2;
            return true;
        }
        return false;
    }

    public void process(PartOfSpeechAnnotationCreator partOfSpeechAnnotationCreator) throws AnalysisEngineProcessException {
        if (this._cas == null || this._method == null) {
            return;
        }
        try {
            if (!this._tokens.isEmpty()) {
                this._method.invoke(this._cas, this._beginIndex, this._endIndex, this._tokens, partOfSpeechAnnotationCreator);
            }
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
        finally {
            this._tokens.clear();
            this._beginIndex = 0;
            this._endIndex = 0;
        }
    }

    public PooledItemAllocator<TokenInfo> getTokenAllocator() {
        return this._tokens;
    }
}

