/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.util;

import com.ibm.dltj.util.ArrayUtils;
import com.ibm.langware.annotator.Copyright;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceAccessException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ConfigurationParameterUtil {
    private final UimaContext _context;

    public ConfigurationParameterUtil(UimaContext uimaContext) {
        this._context = uimaContext;
    }

    private <K, V> V getGlobalValue(K k, V v, Class<V> clazz) {
        String string = k instanceof Enum ? ((Enum)k).name() : k.toString();
        Object object = this._context.getConfigParameterValue(string);
        if (object != null && clazz.isAssignableFrom(object.getClass())) {
            return (V)object;
        }
        return v;
    }

    private <G, K, V> V getValue(G g, K k, V v, Class<V> clazz) {
        String string;
        String string2 = g instanceof Language ? ((Language)g).getFullLanguage() : g.toString();
        Object object = this._context.getConfigParameterValue(string2, string = k instanceof Enum ? ((Enum)k).name() : k.toString());
        if (object != null && clazz.isAssignableFrom(object.getClass())) {
            return (V)object;
        }
        return v;
    }

    public <K> boolean containsGlobalKey(K k) {
        return null != this.getGlobalValue(k, null, Object.class);
    }

    public <G, K> boolean containsKey(G g, K k) {
        return null != this.getValue(g, k, null, Object.class);
    }

    public <K> String getGlobalString(K k) {
        return this.getGlobalValue(k, "", String.class);
    }

    public <K> String getGlobalString(K k, String string) {
        return this.getGlobalValue(k, string, String.class);
    }

    public <G, K> String getString(G g, K k) {
        return this.getValue(g, k, "", String.class);
    }

    public <G, K> String getString(G g, K k, String string) {
        return this.getValue(g, k, string, String.class);
    }

    public <K> String[] getGlobalStringArray(K k) {
        return this.getGlobalValue(k, DefaultValue.STRING_ARRAY, String[].class);
    }

    public <K> String[] getGlobalStringArray(K k, String[] stringArray) {
        return this.getGlobalValue(k, stringArray, String[].class);
    }

    public <G, K> String[] getStringArray(G g, K k) {
        return this.getValue(g, k, DefaultValue.STRING_ARRAY, String[].class);
    }

    public <G, K> String[] getStringArray(G g, K k, String[] stringArray) {
        return this.getValue(g, k, stringArray, String[].class);
    }

    public <K> boolean getGlobalBoolean(K k) {
        return this.getGlobalValue(k, false, Boolean.class);
    }

    public <K> boolean getGlobalBoolean(K k, boolean bl) {
        return this.getGlobalValue(k, bl, Boolean.class);
    }

    public <G, K> boolean getBoolean(G g, K k) {
        return this.getValue(g, k, false, Boolean.class);
    }

    public <G, K> boolean getBoolean(G g, K k, boolean bl) {
        return this.getValue(g, k, bl, Boolean.class);
    }

    public <K> int getGlobalInteger(K k) {
        return this.getGlobalValue(k, 0, Integer.class);
    }

    public <K> int getGlobalInteger(K k, int n) {
        return this.getGlobalValue(k, n, Integer.class);
    }

    public <G, K> int getInteger(G g, K k) {
        return this.getValue(g, k, 0, Integer.class);
    }

    public <G, K> int getInteger(G g, K k, int n) {
        return this.getValue(g, k, n, Integer.class);
    }

    public <K> float getGlobalFloat(K k) {
        return this.getGlobalValue(k, Float.valueOf(0.0f), Float.class).floatValue();
    }

    public <K> float getGlobalFloat(K k, float f) {
        return this.getGlobalValue(k, Float.valueOf(f), Float.class).floatValue();
    }

    public <G, K> float getFloat(G g, K k) {
        return this.getValue(g, k, Float.valueOf(0.0f), Float.class).floatValue();
    }

    public <G, K> float getFloat(G g, K k, float f) {
        return this.getValue(g, k, Float.valueOf(f), Float.class).floatValue();
    }

    public <G, K> URI getResourceURI(String string, G g, K k) {
        String string2 = g instanceof Language ? ((Language)g).getFullLanguage() : g.toString();
        String string3 = k instanceof Enum ? ((Enum)k).name() : k.toString();
        URI uRI = null;
        URI uRI2 = null;
        File file = null;
        String string4 = this.getString(string2, string3);
        if (string4.length() == 0) {
            return null;
        }
        file = new File(string4);
        uRI2 = file.toURI();
        if (file.exists() && file.isAbsolute()) {
            return uRI2;
        }
        try {
            uRI = this._context.getResourceURI(string, new String[]{string2});
            if (uRI != null && (file = new File(uRI2 = uRI.resolve(string4))).exists()) {
                return uRI2;
            }
        }
        catch (ResourceAccessException resourceAccessException) {
            // empty catch block
        }
        try {
            uRI = this._context.getResourceURI(string, new String[]{""});
            if (uRI != null && (file = new File(uRI2 = uRI.resolve(string4))).exists()) {
                return uRI2;
            }
        }
        catch (ResourceAccessException resourceAccessException) {
            // empty catch block
        }
        try {
            String string5 = this._context.getDataPath();
            if (string5 != null) {
                for (String string6 : string5.split(File.pathSeparator)) {
                    file = new File(string6, string4);
                    if (!file.exists()) continue;
                    return file.getCanonicalFile().toURI();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static interface DefaultValue {
        public static final boolean BOOLEAN = false;
        public static final int INT = 0;
        public static final float FLOAT = 0.0f;
        public static final String STRING = "";
        public static final String[] STRING_ARRAY = ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

