/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.mq.message.SmartsModuleStartMessage;
import com.ibm.smarts.common.mq.progress.SmartsModuleCancel;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgress;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.api.BaseApi;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.mq.TypedMessageProducer;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.api.IDataDescriptorService;
import com.ibm.smarts.dds.api.ISmartsModuleDescriptor;
import com.ibm.smarts.dds.core.SmartModuleDescriptor;
import com.ibm.smarts.dds.core.function.DdsSmartsModuleTasks;
import com.ibm.smarts.model.common.util.SmartsModuleBuilder;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDescriptorService
extends BaseApi
implements IDataDescriptorService,
IComponentLifecycle,
IManagedLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDescriptorService.class);
    static final long SMARTS_MODULE_POLLING_INTERVAL = 1L;
    static final TimeUnit SMARTS_MODULE_POLLING_INTERVAL_UNIT = TimeUnit.SECONDS;
    private final IDataProvider mDataProvider;
    private final IStoreProvider mStoreProvider;
    private final MessageQueueingSystem mMessageSystem;
    private ScheduledExecutorService completionExecutor;
    private final LifecycleManager clh;

    public DataDescriptorService(IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageSystem) {
        this.mDataProvider = dataProvider;
        this.mStoreProvider = storeProvider;
        this.mMessageSystem = messageSystem;
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DataDescriptorService @" + Integer.toHexString(((Object)((Object)this)).hashCode()));
        sb.append(" dataProvider=" + this.mDataProvider);
        sb.append(" storeProvider=" + this.mStoreProvider);
        sb.append(" messaging=" + this.mMessageSystem);
        sb.append("]");
        return sb.toString();
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        LOGGER.info("<TCL> Component DDS Initializing...");
        List unregisteredTasks = SmartsModuleMessageGroup.findUnregisteredTasks((IStoreProvider)this.mStoreProvider, (String[])DdsSmartsModuleTasks.ALL_TASKS_FOR_REGISTRATION);
        if (!unregisteredTasks.isEmpty()) {
            DdsSmartsModuleTasks tasks = new DdsSmartsModuleTasks(this.mStoreProvider, this.mDataProvider, this.mMessageSystem);
            tasks.configure(unregisteredTasks);
        }
        if (this.completionExecutor == null) {
            this.completionExecutor = Executors.newSingleThreadScheduledExecutor();
        } else {
            LOGGER.error("<TCL> Component initialize DDS: DDS was already initialized");
        }
        LOGGER.info("<TCL> Component DDS initialized.");
    }

    public void shutDown(RequestContext rc) {
        LOGGER.info("<TCL> Component DDS shutting down...");
        if (this.completionExecutor != null) {
            this.completionExecutor.shutdown();
            this.completionExecutor = null;
        } else {
            LOGGER.error("<TCL> Component shutdown DDS: DDS was not previously initialized");
        }
        LOGGER.info("<TCL> Component DDS shut down complete.");
    }

    public ISmartsModuleDescriptor getSmartsModule(RequestContext ctx, String moduleId) {
        return this.getSmartsModule(ctx, moduleId, null, null);
    }

    public ISmartsModuleDescriptor getSmartsModule(RequestContext ctx, String moduleId, Module module, Set<String> excludedTables) {
        Module dataModule;
        IInMemoryModuleStore smartModuleStore = this.mStoreProvider.getModuleStore(ctx);
        SmartsModule current = null;
        Module module2 = dataModule = module != null ? module : this.mDataProvider.getModule(ctx, moduleId);
        if (dataModule == null) {
            LOGGER.error("no data module found for {}", (Object)moduleId);
            throw new IllegalArgumentException("no data module found for " + moduleId);
        }
        SmartsModuleBuilder builder = new SmartsModuleBuilder();
        current = builder.buildIntermediateSmartsModuleFromModule(moduleId, dataModule, excludedTables);
        smartModuleStore.deleteById(current.getId());
        StoreStatus status = smartModuleStore.store(IRecord.create((Object)current, (String)current.getId()), null);
        if (!status.isSuccess()) {
            throw new InternalException("failed to store smarts module " + moduleId, new Object[0]);
        }
        this.postStartMessage(ctx, current);
        SmartsModuleProgress progress = new SmartsModuleProgress(SmartsModuleMessageGroup.getSmartsModuleTasks((IStoreProvider)this.mStoreProvider));
        return new SmartModuleDescriptor(ctx, moduleId, current, progress, this::getCompleteSmartsModule);
    }

    private void postStartMessage(RequestContext context, SmartsModule smartsModule) {
        SmartsModuleProgressUtil.createProgressRecord((IStoreProvider)this.mStoreProvider, (String)smartsModule.getId(), (int)smartsModule.getDatasets().size());
        SmartsModuleStartMessage start = new SmartsModuleStartMessage(smartsModule);
        TypedMessageProducer producer = this.mMessageSystem.getMessageProducerProvider(context).producer(SmartsModuleStartMessage.class);
        producer.takeMessage(SmartsModuleMessageGroup.DEFAULT_SMARTS_MODULE_START_QUEUE, (Object)start);
    }

    public boolean deleteSmartsModule(RequestContext context, String moduleId) {
        IInMemoryModuleStore store = this.mStoreProvider.getModuleStore(context);
        StoreStatus status = store.deleteById(moduleId);
        return status.isSuccess();
    }

    private CompletableFuture<SmartsModule> getCompleteSmartsModule(RequestContext requestContext, String smartsModuleId) {
        CompletableFuture<SmartsModule> completeSmartsModule = new CompletableFuture<SmartsModule>();
        ScheduledFuture<?> checkFuture = this.completionExecutor.scheduleAtFixedRate(() -> {
            SmartsModuleProgress progress = SmartsModuleProgressUtil.getSmartsModuleProgress((IStoreProvider)this.mStoreProvider, (String)smartsModuleId);
            if (progress == null || progress.isDone()) {
                IInMemoryModuleStore store = this.mStoreProvider.getModuleStore(requestContext);
                SmartsModule smartsModule = store.getById(smartsModuleId);
                completeSmartsModule.complete(smartsModule);
            }
        }, 0L, 1L, SMARTS_MODULE_POLLING_INTERVAL_UNIT);
        completeSmartsModule.whenComplete((result, thrown) -> checkFuture.cancel(true));
        return completeSmartsModule;
    }

    public CompletableFuture<SmartsModule> getSmartsModuleFromPersistenceProvider(RequestContext context, String smartsModuleId) {
        throw new NotImplementedException("getSmartsModuleFromPersistenceProvider is not implemented.");
    }

    public StoreStatus deleteSmartsModuleFromPersistenceProvider(RequestContext context, String smartsModuleId) {
        StoreConfig config = new StoreConfig(context.locale, TypeNames.DDS);
        return this.mStoreProvider.getPersistenceProvider(config).delete(context, smartsModuleId, "", Collections.emptyList());
    }

    public SmartsModuleProgress getProgress(RequestContext context, String smartsModuleId) {
        SmartsModuleProgress progress = SmartsModuleProgressUtil.getSmartsModuleProgress((IStoreProvider)this.mStoreProvider, (String)smartsModuleId);
        if (progress == null) {
            try {
                SmartsModule smarts = this.getSmartsModuleFromPersistenceProvider(context, smartsModuleId).get();
                if (smarts != null) {
                    progress = SmartsModuleProgressUtil.getSmartsModuleProgress((IStoreProvider)this.mStoreProvider, (SmartsModule)smarts);
                    progress.setCompletedSmartsModule(SmartsModuleProgressUtil.stripPrivateSmartsModuleFields((SmartsModule)smarts));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("failed getting smarts module from store", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return progress;
    }

    public SmartsModuleCancel cancelSmartModule(RequestContext context, String smartsModuleId, CancelOption cancelOption) {
        return SmartsModuleProgressUtil.cancelSmartsModule((RequestContext)context, (IStoreProvider)this.mStoreProvider, (String)smartsModuleId, (CancelOption)cancelOption);
    }

    public SmartsModuleCancel deleteSmartModule(RequestContext context, String smartsModuleId) {
        return SmartsModulePublishUtil.deleteSmartsModule((RequestContext)context, (IStoreProvider)this.mStoreProvider, (String)smartsModuleId);
    }
}

