/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.numerics;

import com.ibm.smarts.dds.core.numerics.BivariateStatistics;
import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.numerics.bivariate.Bivariate;
import com.ibm.smarts.dds.core.stats.strategy.CommonStatsStrategy;
import com.ibm.smarts.dds.core.stats.strategy.NominalStatsStrategy;
import com.ibm.smarts.dds.core.stats.strategy.NumericStatsStrategy;
import com.ibm.smarts.dds.core.stats.strategy.StatsStrategy;
import com.ibm.smarts.dds.core.stats.strategy.TemporalStatsStrategy;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StatsAnalysis {
    List<Column> columns = null;
    BivariateStatistics bivariates = null;
    private static final String INDEX_ERROR = "Bad column index requested: ";

    public StatsAnalysis(Map<String, DataType> columnDatatypes, Map<String, List<String>> data) {
        this.columns = data.entrySet().stream().map(anEntry -> new Column((String)anEntry.getKey(), (DataType)columnDatatypes.get(anEntry.getKey()), this.getStrategy((DataType)columnDatatypes.get(anEntry.getKey())), (List)anEntry.getValue())).collect(Collectors.toList());
        this.columns.forEach(Column::calculateStats);
        this.bivariates = new BivariateStatistics(this.columns);
    }

    private StatsStrategy getStrategy(DataType type) {
        CommonStatsStrategy statsStrategy = null;
        switch (type.getBaseType()) {
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: 
            case SHORT: 
            case BYTE: {
                statsStrategy = new NumericStatsStrategy();
                break;
            }
            case STRING: 
            case BOOLEAN: {
                statsStrategy = new NominalStatsStrategy();
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                statsStrategy = new TemporalStatsStrategy();
                break;
            }
            case UNKNOWN: {
                statsStrategy = new NominalStatsStrategy();
            }
        }
        return statsStrategy;
    }

    public Map<StatsKey, Value> univariateInfo(int index) {
        if (index < 0 || index > this.columns.size()) {
            throw new IllegalArgumentException(INDEX_ERROR + index);
        }
        Column column = this.columns.get(index);
        return column.getStat();
    }

    public Bivariate getBivariateStats(int indexI, int indexJ) {
        if (indexI < 0 || indexI > this.columns.size()) {
            throw new IllegalArgumentException(INDEX_ERROR + indexI);
        }
        if (indexJ < 0 || indexJ > this.columns.size()) {
            throw new IllegalArgumentException(INDEX_ERROR + indexJ);
        }
        return this.bivariates.get(this.columns.get(indexI), this.columns.get(indexJ));
    }

    public Map<String, Column> getColumnsByIdMap() {
        HashMap<String, Column> result = new HashMap<String, Column>();
        this.columns.forEach(col -> result.put(col.getId(), (Column)col));
        return result;
    }
}

