/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.stats.strategy;

import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.stats.strategy.CommonStatsStrategy;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.LongValue;
import com.ibm.smarts.model.value.Value;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericStatsStrategy
extends CommonStatsStrategy {
    private static final Logger logger = LoggerFactory.getLogger(NumericStatsStrategy.class);

    @Override
    public void calculateStats(Column column) {
        if (column.getSamples().isEmpty()) {
            logger.info("There are no samples for column: {} statistics will not be calculated", (Object)column.getId());
            return;
        }
        super.calculateStats(column);
        HashSet<Double> distinct = new HashSet<Double>();
        List<Double> dataList = column.getSamples().stream().filter(Objects::nonNull).map(column::toDouble).sorted().collect(Collectors.toList());
        double minSample = 0.0;
        double maxSample = 0.0;
        int distinctCount = 0;
        int count = 0;
        double avg = 0.0;
        if (!dataList.isEmpty()) {
            minSample = (Double)dataList.get(0);
            count = dataList.size();
            maxSample = (Double)dataList.get(count - 1);
        }
        for (Double sample : dataList) {
            distinct.add(sample);
            avg += sample.doubleValue();
        }
        avg /= (double)count;
        distinctCount = distinct.size();
        column.setUnivariateStat(StatsKey.validNumeric, (Value)new IntegerValue(count));
        column.setUnivariateStat(StatsKey.valid, (Value)new IntegerValue(count));
        column.setUnivariateStat(StatsKey.unique, (Value)new LongValue((long)distinctCount));
        if (column.getDataType().isInteger()) {
            column.setUnivariateStat(StatsKey.min, (Value)new LongValue((long)minSample));
            column.setUnivariateStat(StatsKey.max, (Value)new LongValue((long)maxSample));
        } else {
            column.setUnivariateStat(StatsKey.min, (Value)new DoubleValue(minSample));
            column.setUnivariateStat(StatsKey.max, (Value)new DoubleValue(maxSample));
        }
        column.setUnivariateStat(StatsKey.unique, (Value)new LongValue((long)distinctCount));
        if (count <= 1) {
            logger.info("There is not enough valid numberic data for column: {} statistics will not be calculated", (Object)column.getId());
            return;
        }
        double mean = avg;
        List<Double> mm = ((Stream)dataList.stream().parallel()).mapToDouble(x -> x - mean).mapToObj(x -> Arrays.asList(x * x, x * x * x, x * x * x * x)).reduce((a, b) -> Arrays.asList((Double)a.get(0) + (Double)b.get(0), (Double)a.get(1) + (Double)b.get(1), (Double)a.get(2) + (Double)b.get(2))).orElse(Arrays.asList(4.0));
        double variance = mm.get(0) / (double)(count - 1);
        double m3 = mm.get(1) / (double)(count - 1);
        double m4 = mm.get(2) / (double)(count - 1);
        double stddev = Math.sqrt(variance);
        column.setUseful(Double.isFinite(stddev));
        column.setUnivariateStat(StatsKey.mean, (Value)new DoubleValue(mean));
        column.setUnivariateStat(StatsKey.stddev, (Value)new DoubleValue(stddev));
        column.setUnivariateStat(StatsKey.variance, (Value)new DoubleValue(variance));
        if (variance != 0.0) {
            column.setUnivariateStat(StatsKey.skew, (Value)new DoubleValue(m3 / variance / Math.sqrt(variance)));
            column.setUnivariateStat(StatsKey.kurtosis, (Value)new DoubleValue(m4 / variance / variance - 3.0));
        } else {
            logger.info("The standard deviation for column: {} was zero! Skew and kurtosis cannot be calculated and will be set to '0'", (Object)column.getId());
            column.setUnivariateStat(StatsKey.skew, (Value)new DoubleValue(0.0));
            column.setUnivariateStat(StatsKey.kurtosis, (Value)new DoubleValue(0.0));
        }
        Double dataMin = column.getStat(StatsKey.min).doubleValue();
        Double dataMax = column.getStat(StatsKey.max).doubleValue();
        column.setUnivariateStat(StatsKey.median, (Value)NumericStatsStrategy.av(dataList, (double)(count - 1) * 0.5));
        if (count % 2 == 0) {
            column.setUnivariateStat(StatsKey.q1, (Value)NumericStatsStrategy.av(dataList, ((double)count / 2.0 - 1.0) * 0.5));
            column.setUnivariateStat(StatsKey.q3, (Value)NumericStatsStrategy.av(dataList, (double)count / 2.0 + ((double)count / 2.0 - 1.0) * 0.5));
        } else {
            column.setUnivariateStat(StatsKey.q1, (Value)NumericStatsStrategy.av(dataList, (double)(count - 1) * 0.25));
            column.setUnivariateStat(StatsKey.q3, (Value)NumericStatsStrategy.av(dataList, (double)(count - 1) / 2.0 + (double)(count - 1) * 0.25));
        }
        double dataGran = dataMax - dataMin;
        boolean allInteger = true;
        if (dataGran == 0.0) {
            dataGran = Math.abs(dataMax);
        }
        for (int i = 1; i < dataList.size(); ++i) {
            double d = dataList.get(i) - dataList.get(i - 1);
            if (d > 0.0) {
                dataGran = Math.min(dataGran, d);
            }
            if (!allInteger || dataList.get(i) == (double)Math.round(dataList.get(i))) continue;
            allInteger = false;
        }
        column.setUnivariateStat(StatsKey.granularity, (Value)new DoubleValue(dataGran));
        double range = dataMax.equals(dataMin) ? (dataMax == 0.0 ? 1.0 : dataMax) : dataMax - dataMin;
        double places = Math.max(0L, Math.round(4.0 - Math.log(range) / Math.log(10.0)));
        column.setUnivariateStat(StatsKey.decimalPlaces, (Value)new DoubleValue(allInteger && dataMax - dataMin > 5.0 ? 0.0 : places));
        this.setDensityEstimation(column);
    }

    private static DoubleValue av(List<Double> v, double index) {
        return new DoubleValue((v.get((int)Math.floor(index)) + v.get((int)Math.ceil(index))) / 2.0);
    }

    @Override
    public int getGroupCount() {
        return 4;
    }

    @Override
    public int getCategoryCount() {
        return -1;
    }

    @Override
    public Map<String, Integer> getCategoryIndex() {
        return null;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

