/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.stats.strategy;

import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.numerics.util.DateUnit;
import com.ibm.smarts.dds.core.stats.strategy.CommonStatsStrategy;
import com.ibm.smarts.dds.core.stats.strategy.NumericStatsStrategy;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueFactory;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalStatsStrategy
extends CommonStatsStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TemporalStatsStrategy.class);

    @Override
    public void calculateStats(Column column) {
        if (column.getSamples().isEmpty()) {
            logger.info("There are no samples for column: {}", (Object)column.getId());
            return;
        }
        super.calculateStats(column);
        new NumericStatsStrategy().calculateStats(column);
        Optional<Value> max = Optional.ofNullable(column.getStat(StatsKey.max));
        Optional<Value> min = Optional.ofNullable(column.getStat(StatsKey.min));
        if (!min.isPresent() || !max.isPresent()) {
            column.setUnivariateStat(StatsKey.dateUnit, null);
        } else {
            double minDouble;
            double maxDouble = max.get().doubleValue();
            double days = maxDouble - (minDouble = min.get().doubleValue());
            if (days == 0.0) {
                days = maxDouble;
            }
            DateUnit unit = TemporalStatsStrategy.getUnit(days);
            column.setUnivariateStat(StatsKey.dateUnit, (Value)ValueFactory.createString((String)unit.toString()));
        }
    }

    private static DateUnit getUnit(double days) {
        for (DateUnit d : DateUnit.values()) {
            if (days > 3.5 * d.approxDaysPerUnit) {
                return d;
            }
            if (d != DateUnit.day || !(days >= 2.5 * d.approxDaysPerUnit)) continue;
            return d;
        }
        return DateUnit.second;
    }

    @Override
    public int getGroupCount() {
        return 4;
    }

    @Override
    public int getCategoryCount() {
        return -1;
    }

    @Override
    public Map<String, Integer> getCategoryIndex() {
        return null;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

