/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchContext {
    private IStoreProvider storeProvider;
    private SmartNLP nlp;
    private KnowledgeDiscoveryService knowledgeDiscoveryService;
    private RequestContext reqCtx;
    private String[] assetRefs;
    private String assetTypes;
    private List<Entity> nluEntities = new ArrayList<Entity>();
    private Map<Entity, NLUEntityContext> entityContextMap = new HashMap<Entity, NLUEntityContext>();
    private boolean inDataValue;
    private Map<MatchReason, Integer> matchReasonRanking = new EnumMap<MatchReason, Integer>(MatchReason.class);

    public SearchContext(RequestContext req, List<Entity> nluEntities, String assetTypes, String[] assetRefs) {
        this.reqCtx = req;
        this.nluEntities = nluEntities;
        this.assetRefs = assetRefs;
        this.assetTypes = assetTypes;
        Object attr = req.getAttribute("inDataValue");
        if (attr != null) {
            this.setInDataValue(Boolean.parseBoolean((String)attr));
        }
        this.initializeEntityContextMap(nluEntities);
        this.initializeMatchReasonRanking(this.matchReasonRanking);
    }

    public void setNlp(SmartNLP nlp) {
        this.nlp = nlp;
    }

    public void setKnowledgeDiscoveryService(KnowledgeDiscoveryService knowledgeDiscoveryService) {
        this.knowledgeDiscoveryService = knowledgeDiscoveryService;
    }

    public List<Entity> getNluEntities() {
        return this.nluEntities;
    }

    public void setNluEntities(List<Entity> nluEntities) {
        this.nluEntities = nluEntities;
    }

    public RequestContext getReqCtx() {
        return this.reqCtx;
    }

    public String getAssetTypes() {
        return this.assetTypes;
    }

    public String[] getAssetRefs() {
        return this.assetRefs;
    }

    public SmartNLP getNlp() {
        return this.nlp;
    }

    public KnowledgeDiscoveryService getKnowledgeDiscoveryService() {
        return this.knowledgeDiscoveryService;
    }

    public boolean isInDataValue() {
        return this.inDataValue;
    }

    public void setInDataValue(boolean inDataValue) {
        this.inDataValue = inDataValue;
    }

    public Map<Entity, NLUEntityContext> getEntityContextMap() {
        return this.entityContextMap;
    }

    public void setEntityContextMap(Map<Entity, NLUEntityContext> entityContextMap) {
        this.entityContextMap = entityContextMap;
    }

    public IStoreProvider getStoreProvider() {
        return this.storeProvider;
    }

    public void setStoreProvider(IStoreProvider storeProvider) {
        this.storeProvider = storeProvider;
    }

    public SemanticSearchResult getSemanticSearchResult() {
        SemanticSearchResult result = new SemanticSearchResult();
        ArrayList matchedEntities = new ArrayList();
        this.nluEntities.forEach(nluEntity -> {
            MatchedEntity entity = new MatchedEntity();
            entity.setCharOffsetBegin((int)nluEntity.getStart());
            entity.setCharOffsetEnd((int)nluEntity.getEnd());
            entity.setCoveredText(nluEntity.getText());
            List<MatchedFeature> features = this.entityContextMap.get(nluEntity).getMatchedFeatures();
            List sortedFeatures = features.stream().sorted(Comparator.comparing(f -> this.matchReasonRanking.get(f.getMatchReason())).reversed().thenComparing(f -> Float.valueOf(f.getConfidence())).thenComparing(f -> Float.valueOf(f.getScore())).thenComparing(f -> f.getFeature().getFeatureKey()).thenComparing(f -> f.getFeature().getCreationDate()).thenComparing(f -> f.getFeature().getLastModifiedDate()).thenComparing(f -> f.getFeature().getIdForExpression() == null ? "N/A" : f.getFeature().getIdForExpression()).thenComparing(f -> f.getFeature().getAssetRef()).reversed()).collect(Collectors.toList());
            entity.getMatchedFeatures().addAll(sortedFeatures);
            matchedEntities.add(entity);
        });
        result.getMatchedEntity().addAll(matchedEntities);
        return result;
    }

    private void initializeEntityContextMap(List<Entity> nluEntities) {
        nluEntities.forEach(entity -> this.entityContextMap.put((Entity)entity, new NLUEntityContext((Entity)entity)));
    }

    private void initializeMatchReasonRanking(Map<MatchReason, Integer> matchReasonRanking) {
        matchReasonRanking.put(MatchReason.FULL, 1);
        matchReasonRanking.put(MatchReason.PARTIAL_NAME, 2);
        matchReasonRanking.put(MatchReason.PARTIAL_LEMMA, 3);
        matchReasonRanking.put(MatchReason.FULL_MULTIPLE_CONCEPT, 4);
        matchReasonRanking.put(MatchReason.SINGLE_CONCEPT, 5);
        matchReasonRanking.put(MatchReason.PARTIAL_CONCEPT, 6);
        matchReasonRanking.put(MatchReason.DATA_VALUE, 7);
        matchReasonRanking.put(MatchReason.NOT_MATCH, 8);
    }
}

