/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.query.IRecordResult;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateConceptResults
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateConceptResults.class);
    private SearchContext searchContext;

    public AggregateConceptResults(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        ArrayList<IRecordResult<Feature>> featureHits = new ArrayList<IRecordResult<Feature>>(entityContext.getRawResultCacheForConcepts().values());
        if (featureHits.isEmpty()) {
            return;
        }
        ArrayList<MatchedFeature> allMatchedFeatures = new ArrayList<MatchedFeature>();
        for (int i = 0; i < featureHits.size(); ++i) {
            MatchedFeature aMatch = SemanticSearchHelper.convertToMatchedFeature((IRecordResult<Feature>)((IRecordResult)featureHits.get(i)));
            aMatch.setMatchReason(SemanticSearchHelper.evaluateConceptMatchReason(entityContext.getConcepts(), aMatch.getFeature()));
            aMatch.setScore(((IRecordResult)featureHits.get(i)).getScore());
            aMatch.setConfidence(SemanticSearchHelper.normalize(aMatch.getScore()));
            allMatchedFeatures.add(aMatch);
        }
        entityContext.getMatchedFeatures().addAll(allMatchedFeatures);
    }
}

