/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.util;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.qa.api.InterpretationUnit;
import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSearchHelper {
    private static final String SPACE = " ";
    private static final String PERIOD = "\\.";
    private static final String COMMA = ",";
    private static final String VALUE_FIELD = "value";
    private static final String ONTOLOGYID_FIELD = "ontologyID";
    private static final float CONFIDENCE_THRESHOLD = 0.5f;
    private static final int MAX_SEARCH_RESULTS = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticSearchHelper.class);

    private static Optional<SemanticAnnotation> getSignificantSemanticAnnotation(SemanticAnnotation sa) {
        if (sa.getConcepts().isEmpty()) {
            return Optional.empty();
        }
        if (sa.getConcepts().size() == 1) {
            ConceptInfo conceptInfo = (ConceptInfo)sa.getConcepts().get(0);
            String saConcept = ConceptsUtil.getConceptName((ConceptInfo)conceptInfo);
            if (sa.getPhraseInfo().getText().equalsIgnoreCase(saConcept) || OntologyCommon.getUnsearcableConceptShortNames().contains(saConcept)) {
                return Optional.empty();
            }
        }
        return Optional.of(sa);
    }

    public static boolean hasSearchableConcept(InterpretationUnit iu) {
        return iu.getSemanticAnnotations().stream().anyMatch(sa -> SemanticSearchHelper.getSignificantSemanticAnnotation(sa).isPresent());
    }

    public static List<SemanticAnnotation> getSearchableSemanticAnnotations(InterpretationUnit iu) {
        return iu.getSemanticAnnotations().stream().filter(sa -> SemanticSearchHelper.getSignificantSemanticAnnotation(sa).isPresent()).collect(Collectors.toList());
    }

    public static String toSearchableQuery(SemanticAnnotation sa) {
        return sa.getConcepts().stream().filter(c -> !OntologyCommon.getUnsearcableConceptShortNames().contains(ConceptsUtil.getConceptName((ConceptInfo)c))).map(ConceptsUtil::getConceptName).collect(Collectors.joining(SPACE));
    }

    public static IStoreQuery buildQuery(RequestContext requestContext, IFeatureStore featureStore, String text, String assetTypes, boolean inDataValue, SemanticQueryType queryType, String[] assetRefs) {
        return SemanticSearchHelper.buildQuery(requestContext, featureStore, text, assetTypes, inDataValue, queryType, assetRefs, null);
    }

    public static IStoreQuery buildQuery(RequestContext requestContext, IFeatureStore featureStore, String text, String assetTypes, boolean inDataValue, SemanticQueryType queryType, String[] assetRefs, Map<QueryFields, Float> boostFactorMap) {
        IStoreQueryBuilder queryBuilder = boostFactorMap != null && !boostFactorMap.isEmpty() ? SemanticSearchHelper.featureQueryBuilder(requestContext, featureStore, text, assetTypes, boostFactorMap) : SemanticSearchHelper.featureQueryBuilder(requestContext, featureStore, text, assetTypes);
        if (inDataValue) {
            if ((SemanticQueryType.VALUE == queryType || SemanticQueryType.CONCEPT == queryType) && ArrayUtils.isNotEmpty((Object[])assetRefs)) {
                SemanticSearchHelper.applyAssetRefFilter(assetRefs, queryBuilder);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])assetRefs)) {
            SemanticSearchHelper.applyAssetRefFilter(assetRefs, queryBuilder);
        }
        return queryBuilder.build();
    }

    private static IStoreQueryBuilder getDefaultStoreQueryBuilder(IFeatureStore featureStore, String text) {
        return featureStore.getQueryBuilder().addQuery(QueryFields.FEATUREKEY.getName(), text, QueryFields.FEATUREKEY.boost()).addQuery(QueryFields.FEATUREKEY_TOKENIZED.getName(), text, QueryFields.FEATUREKEY_TOKENIZED.boost()).addQuery(QueryFields.FEATUREKEY_LEMMA.getName(), text, QueryFields.FEATUREKEY_LEMMA.boost()).addQuery(QueryFields.SEARCHABLE_CONCEPTS.getName(), text, QueryFields.SEARCHABLE_CONCEPTS.boost()).addQuery(QueryFields.FEATUREKEY_LC.getName(), text, QueryFields.FEATUREKEY_LC.boost());
    }

    public static IStoreQueryBuilder featureQueryBuilder(RequestContext requestContext, IFeatureStore featureStore, String text, String assetTypes, Map<QueryFields, Float> boostFactorMap) {
        IStoreQueryBuilder queryBuilder = boostFactorMap != null && !boostFactorMap.isEmpty() ? featureStore.getQueryBuilder().addQuery(QueryFields.FEATUREKEY.getName(), text, boostFactorMap.getOrDefault((Object)QueryFields.FEATUREKEY, Float.valueOf(QueryFields.FEATUREKEY.boost())).floatValue()).addQuery(QueryFields.FEATUREKEY_TOKENIZED.getName(), text, boostFactorMap.getOrDefault((Object)QueryFields.FEATUREKEY_TOKENIZED, Float.valueOf(QueryFields.FEATUREKEY_TOKENIZED.boost())).floatValue()).addQuery(QueryFields.FEATUREKEY_LEMMA.getName(), text, boostFactorMap.getOrDefault((Object)QueryFields.FEATUREKEY_LEMMA, Float.valueOf(QueryFields.FEATUREKEY_LEMMA.boost())).floatValue()).addQuery(QueryFields.SEARCHABLE_CONCEPTS.getName(), text, boostFactorMap.getOrDefault((Object)QueryFields.SEARCHABLE_CONCEPTS, Float.valueOf(QueryFields.SEARCHABLE_CONCEPTS.boost())).floatValue()).addQuery(QueryFields.FEATUREKEY_LC.getName(), text, boostFactorMap.getOrDefault((Object)QueryFields.FEATUREKEY_LC, Float.valueOf(QueryFields.FEATUREKEY_LC.boost())).floatValue()) : SemanticSearchHelper.getDefaultStoreQueryBuilder(featureStore, text);
        SemanticSearchHelper.addFilterToQueryBuilder(requestContext, assetTypes, queryBuilder);
        return queryBuilder;
    }

    public static IStoreQueryBuilder featureQueryBuilder(RequestContext requestContext, IFeatureStore featureStore, String text, String assetTypes) {
        IStoreQueryBuilder queryBuilder = SemanticSearchHelper.getDefaultStoreQueryBuilder(featureStore, text);
        SemanticSearchHelper.addFilterToQueryBuilder(requestContext, assetTypes, queryBuilder);
        return queryBuilder;
    }

    private static void addFilterToQueryBuilder(RequestContext requestContext, String assetTypes, IStoreQueryBuilder queryBuilder) {
        if (assetTypes != null && !assetTypes.isEmpty()) {
            queryBuilder.addFilter(FilterFields.ASSETTYPES.getName(), new String[]{assetTypes});
        }
        if (requestContext != null && requestContext.getCredentials() != null && StringUtils.isNotBlank((CharSequence)requestContext.getCredentials().getTenantId())) {
            queryBuilder.addFilter(FilterFields.TENANTID.getName(), new String[]{requestContext.getCredentials().getTenantId()});
        }
    }

    public static void applyAssetRefFilter(String[] assetRefs, IStoreQueryBuilder queryBuilder) {
        queryBuilder.addFilter(FilterFields.ASSETREF.getName(), (String[])Arrays.stream(assetRefs).filter(assetRef -> !StringUtils.isBlank((CharSequence)assetRef)).toArray(String[]::new));
    }

    public static boolean hasMatchedByConcept(Feature feature, TokenInfo t) {
        if (feature.getSearchableConcepts().isEmpty()) {
            return false;
        }
        List conceptsLC = feature.getSearchableConcepts().stream().map(String::toLowerCase).collect(Collectors.toList());
        return conceptsLC.contains(t.getText()) || conceptsLC.contains(t.getLemma());
    }

    public static boolean hasMatchedByLemma(Feature feature, String lemma) {
        return !StringUtils.isBlank((CharSequence)feature.getFeatureKeyTokenized()) && feature.getFeatureKeyTokenized().contains(lemma) || !StringUtils.isBlank((CharSequence)feature.getFeatureKeyLemma()) && feature.getFeatureKeyLemma().contains(lemma);
    }

    public static boolean hasMatchedByToken(Feature feature, String token) {
        return !StringUtils.isBlank((CharSequence)feature.getFeatureKeyTokenized()) && feature.getFeatureKeyTokenized().contains(token);
    }

    public static void debugRawFeatureHits(List<IRecordResult<Feature>> featureHits, Logger logger, String msg) {
        if (logger.isDebugEnabled()) {
            StringBuilder sbd = new StringBuilder().append(msg);
            for (IRecordResult<Feature> f : featureHits) {
                sbd.append(String.format("\n[Score: %s | ID: %s]\n", Float.valueOf(f.getScore()), f.getRecord().getId()));
                sbd.append(CommonJAXBHelper.marshalToJSON((Object)f.getRecord().getRecord(), (boolean)true));
            }
            logger.debug("\n" + sbd.toString());
        }
    }

    public static MatchedFeature convertToMatchedFeature(IRecordResult<Feature> hit) {
        MatchedFeature aMatch = new MatchedFeature();
        aMatch.setFeature((Feature)hit.getRecord().getRecord());
        aMatch.setFeatureType(aMatch.getFeature().getFeatureType());
        return aMatch;
    }

    public static MatchReason evaluateMatchReason(PhraseInfo phraseInfo, Feature feature) {
        if (!StringUtils.isBlank((CharSequence)phraseInfo.getText()) && phraseInfo.getText().equalsIgnoreCase(feature.getFeatureKey())) {
            return MatchReason.FULL;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByToken(feature, t.getText()))) {
            return MatchReason.PARTIAL_NAME;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByLemma(feature, t.getLemma()))) {
            return MatchReason.PARTIAL_LEMMA;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByConcept(feature, t))) {
            return MatchReason.PARTIAL_CONCEPT;
        }
        return MatchReason.PARTIAL_NAME;
    }

    public static MatchReason evaluateConceptMatchReason(List<ConceptInfo> cList, Feature feature) {
        List<ConceptInfo> concepts = SemanticSearchHelper.getAcceptableConcepts(cList);
        List nluConcepts = concepts.stream().map(concept -> ConceptsUtil.getConceptName((ConceptInfo)concept).toLowerCase()).collect(Collectors.toList());
        List featureConcepts = feature.getSearchableConcepts().stream().map(String::toLowerCase).collect(Collectors.toList());
        if (nluConcepts.size() == 1 && featureConcepts.containsAll(nluConcepts)) {
            return MatchReason.SINGLE_CONCEPT;
        }
        if (nluConcepts.size() > 1 && featureConcepts.containsAll(nluConcepts)) {
            return MatchReason.FULL_MULTIPLE_CONCEPT;
        }
        return MatchReason.PARTIAL_CONCEPT;
    }

    public static IStoreQuery buildValueQuery(IDataClueStore dataClueStore, String question) {
        question = question.replaceAll(PERIOD, SPACE).replaceAll(COMMA, SPACE);
        IStoreQueryBuilder queryBuilder = dataClueStore.getQueryBuilder().addQuery(VALUE_FIELD, question);
        queryBuilder.addFilter(ONTOLOGYID_FIELD, new String[]{"http://www.ibm.com/ontologies/waca/domain/common"});
        return queryBuilder.build();
    }

    public static float normalize(float featureScore) {
        return (float)(1.0 - Math.exp(-featureScore));
    }

    public static List<Float> normalizeScore(List<Float> scores) {
        ArrayList<Float> normalizedScores = new ArrayList<Float>();
        float mean = (float)scores.stream().mapToDouble(s -> s.floatValue()).average().orElse(0.0);
        float temp = 0.0f;
        for (float num : scores) {
            temp = (float)((double)temp + Math.pow(num - mean, 2.0));
        }
        float std = (float)Math.sqrt(temp / (float)scores.size());
        for (float score : scores) {
            if (std == 0.0f) {
                normalizedScores.add(Float.valueOf(score / score));
                continue;
            }
            float zScore = (score - mean) / std;
            if ((double)zScore < -2.0) {
                zScore = -2.0f;
            } else if ((double)zScore > 2.0) {
                zScore = 2.0f;
            }
            zScore /= 5.0f;
            zScore = (float)((double)zScore + 0.5);
            normalizedScores.add(Float.valueOf(zScore));
        }
        return normalizedScores;
    }

    public static List<ConceptInfo> getAcceptableConcepts(List<ConceptInfo> conceptInfoList) {
        List<ConceptInfo> conceptList;
        if (conceptInfoList != null && !conceptInfoList.isEmpty() && !(conceptList = conceptInfoList.stream().filter(c -> !"http://www.ibm.com/ontologies/waca/application".equals(ConceptsUtil.getOntologyId((ConceptInfo)c))).filter(c -> Float.compare(c.getConfidence(), 0.5f) > 0).filter(c -> !OntologyCommon.getUnsearcableConceptShortNames().contains(ConceptsUtil.getConceptName((ConceptInfo)c))).collect(Collectors.toList())).isEmpty()) {
            return conceptList;
        }
        return Collections.emptyList();
    }

    public static void appendQueryByAssetRefsHitsIfInDataValue(List<IRecordResult<Feature>> featureHits, SearchContext searchContext, IFeatureStore featureStore, String queryString) {
        if (searchContext.isInDataValue() && featureHits.size() == 500 && ArrayUtils.isNotEmpty((Object[])searchContext.getAssetRefs())) {
            IStoreQueryBuilder queryBuilder = SemanticSearchHelper.featureQueryBuilder(searchContext.getReqCtx(), featureStore, queryString, searchContext.getAssetTypes());
            SemanticSearchHelper.applyAssetRefFilter(searchContext.getAssetRefs(), queryBuilder);
            List filteredFeatureHits = featureStore.executeSearch(queryBuilder.build());
            SemanticSearchHelper.debugRawFeatureHits(filteredFeatureHits, LOGGER, String.format("querySearch with query: [%s]", queryString));
            List uniqueHits = filteredFeatureHits.stream().filter(filtered -> !featureHits.stream().anyMatch(unFiltered -> unFiltered.getRecord().getId().equals(filtered.getRecord().getId()))).collect(Collectors.toList());
            featureHits.addAll(uniqueHits);
        }
    }

    public static String expandQuery(PhraseInfo phrase, SearchContext searchContext) {
        ArrayList<String> words = new ArrayList<String>();
        words.add(phrase.getText());
        String phraseTextLC = phrase.getText().toLowerCase(searchContext.getReqCtx().locale);
        SemanticSearchHelper.addTokensIfRequired(words, phraseTextLC, phrase, searchContext.getReqCtx());
        SemanticSearchHelper.addLemmaIfRequired(words, phrase);
        return words.stream().reduce("", (s1, s2) -> String.join((CharSequence)SPACE, s1, s2)).trim();
    }

    private static void addLemmaIfRequired(List<String> words, PhraseInfo phrase) {
        phrase.getTokens().stream().filter(t -> !t.getText().equalsIgnoreCase(t.getLemma())).forEach(t -> words.add(t.getLemma()));
    }

    private static void addTokensIfRequired(List<String> words, String phraseTextLC, PhraseInfo phrase, RequestContext reqCtx) {
        phrase.getTokens().stream().filter(t -> !phraseTextLC.contains(t.getText().toLowerCase(reqCtx.locale))).forEach(t -> words.add(t.getText()));
    }

    private static int findLCS(String str1, String str2) {
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (int i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]);
            }
        }
        return dp[str1.length()][str2.length()];
    }

    public static float findEditDistance(String str1, String str2) {
        int lcs = SemanticSearchHelper.findLCS(str1, str2);
        return (float)(str1.length() + str2.length() - 2 * lcs) / (float)(str1.length() + str2.length());
    }

    private static enum FilterFields {
        SMARTSMODULEREF("smartsModuleRef"),
        ASSETREF("assetRef"),
        ASSETTYPES("assetTypes"),
        TENANTID("tenantID");

        private String name;

        private FilterFields(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum QueryFields {
        FEATUREKEY("featureKey", 2.0f),
        FEATUREKEY_TOKENIZED("featureKeyTokenized", 1.7f),
        FEATUREKEY_LEMMA("featureKeyLemma", 1.6f),
        FEATUREKEY_LC("featureKeyLC", 1.0f),
        SEARCHABLE_CONCEPTS("searchableConcepts", 1.0f);

        private String name;
        private float boost;

        public float boost() {
            return this.boost;
        }

        private QueryFields(String name, float boost) {
            this.name = name;
            this.boost = boost;
        }

        public String getName() {
            return this.name;
        }
    }
}

