/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.log;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.questionanalyzer.core.interpretation.Interpretation;
import java.util.List;

public class Report {
    private static final String STEP = "step";
    public static final String ANNOTATOR = "annotator";
    public static final String MERGER = "merger";
    public static final String ARBITRATOR = "arbitrator";
    private static final String NAME = "name";
    private static final String RESULTS = "results";
    private static final String TIME = "time";
    private static final String ERROR = "error";
    private static final String INPUT = "input";
    JSONArray steps = new JSONArray();
    JSONObject currStep;

    public void enterStep(String stepName) {
        this.currStep = new JSONObject();
        this.currStep.put((Object)STEP, (Object)stepName);
        this.currStep.put((Object)ANNOTATOR, (Object)new JSONArray());
        this.currStep.put((Object)MERGER, (Object)new JSONArray());
        this.currStep.put((Object)ARBITRATOR, (Object)new JSONArray());
        this.steps.add((Object)this.currStep);
    }

    public void logErrorOutput(String annotatorName, String type, String error) {
        JSONObject annotator = new JSONObject();
        annotator.put((Object)NAME, (Object)annotatorName);
        annotator.put((Object)ERROR, (Object)error);
        JSONArray annotators = (JSONArray)this.currStep.get((Object)type);
        annotators.add((Object)annotator);
    }

    public void logOutput(String annotatorName, String type, Interpretation interpretation, long elapsedTime) {
        JSONObject annotator = new JSONObject();
        annotator.put((Object)NAME, (Object)annotatorName);
        double time = (double)elapsedTime / 1000000.0;
        annotator.put((Object)TIME, (Object)time);
        JSONArray results = new JSONArray();
        annotator.put((Object)RESULTS, (Object)results);
        String interpretationText = null == interpretation ? "!!!interpretation is NULL!!!" : interpretation.toText();
        results.add((Object)interpretationText);
        JSONArray annotators = (JSONArray)this.currStep.get((Object)type);
        annotators.add((Object)annotator);
    }

    public void logOutput(String annotatorName, String type, Interpretation input, List<Interpretation> interpretations, long elapsedTime) {
        JSONObject annotator = new JSONObject();
        annotator.put((Object)NAME, (Object)annotatorName);
        double time = (double)elapsedTime / 1000000.0;
        annotator.put((Object)TIME, (Object)time);
        JSONArray results = new JSONArray();
        if (input != null) {
            annotator.put((Object)INPUT, (Object)input.toText());
        }
        annotator.put((Object)RESULTS, (Object)results);
        for (Interpretation inter : interpretations) {
            results.add((Object)inter.toText());
        }
        JSONArray annotators = (JSONArray)this.currStep.get((Object)type);
        annotators.add((Object)annotator);
    }

    public void logOutput(String annotatorName, String type, List<Interpretation> interpretations, long elapsedTime) {
        this.logOutput(annotatorName, type, null, interpretations, elapsedTime);
    }

    public void logTime(long elapsedTime) {
        double time = (double)elapsedTime / 1000000.0;
        this.currStep.put((Object)TIME, (Object)time);
    }

    public String toString() {
        return this.steps.toString();
    }
}

