/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.function;

import com.ibm.smarts.common.rest.util.RestServiceUtil;
import com.ibm.smarts.model.progress.SmartsModuleProgressSummary;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.smartsmodule.builder.validation.AnalysisScopeValidator;
import com.ibm.smarts.smartsmodule.builder.validation.ValidationErrors;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressHandler.class);
    public static final String MSG_CAN_NOT_PARSE_QUERY_PARAMS = "Can not parse query params";

    private ProgressHandler() {
    }

    public static Response handle(String analysisScope, String resourceUri, Function<AnalysisScope, SmartsModuleProgressSummary> getProgress) {
        try {
            Optional<ValidationErrors> validationResultOptional;
            AnalysisScope scope = null;
            if (!StringUtils.isBlank((CharSequence)analysisScope)) {
                scope = (AnalysisScope)JAXBHelper.unmarshalJaxbAnnotatedObjectFromJSON(AnalysisScope.class, (String)analysisScope);
            }
            if ((validationResultOptional = AnalysisScopeValidator.validate(scope)).isPresent()) {
                ValidationErrors validationErrors = validationResultOptional.get();
                LOGGER.error("Failed to get progress of SmartsModule {} with payload {} and errors {}", new Object[]{resourceUri, analysisScope, validationErrors});
                return RestServiceUtil.createResponse((Response.Status)Response.Status.BAD_REQUEST, (Object)validationErrors);
            }
            SmartsModuleProgressSummary progress = getProgress.apply(scope);
            if (progress == null) {
                return RestServiceUtil.notFound();
            }
            if (progress.isFinished()) {
                return RestServiceUtil.createResponse((Response.Status)Response.Status.OK, (Object)progress);
            }
            return RestServiceUtil.createResponse((Response.Status)Response.Status.ACCEPTED, (Object)progress);
        }
        catch (IOException e) {
            LOGGER.error(MSG_CAN_NOT_PARSE_QUERY_PARAMS, (Throwable)e);
            return RestServiceUtil.createResponse((Response.Status)Response.Status.BAD_REQUEST, (Object)MSG_CAN_NOT_PARSE_QUERY_PARAMS);
        }
    }
}

