/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.validation;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.model.builder.KnowledgeDiscoveryRequest;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.smartsmodule.builder.validation.KDSStatus;
import com.ibm.smarts.smartsmodule.builder.validation.ValidationError;
import com.ibm.smarts.smartsmodule.builder.validation.ValidationErrors;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class KnowledgeDiscoveryRequestValidator {
    private static final Map<Predicate<KnowledgeDiscoveryRequest>, KDSStatus> criticalErrors = new LinkedHashMap<Predicate<KnowledgeDiscoveryRequest>, KDSStatus>();
    private static final List<Function<Module.UseSpec, ValidationError>> useSpecValidationRules = new ArrayList<Function<Module.UseSpec, ValidationError>>();
    private static final List<Function<QueryItem, ValidationError>> queryItemValidationRules = new ArrayList<Function<QueryItem, ValidationError>>();
    public static final String FIELD_QUERY_ITEM = "queryItem";

    private KnowledgeDiscoveryRequestValidator() {
    }

    public static Optional<ValidationErrors> validate(KnowledgeDiscoveryRequest kdsRequest) {
        Optional<Map.Entry<Predicate<KnowledgeDiscoveryRequest>, KDSStatus>> stopper = KnowledgeDiscoveryRequestValidator.validateCriticalError(kdsRequest);
        if (stopper.isPresent()) {
            return Optional.of(new ValidationErrors(stopper.get().getValue()));
        }
        List<ValidationError> moduleErrors = KnowledgeDiscoveryRequestValidator.validateModule(kdsRequest);
        if (!moduleErrors.isEmpty()) {
            return Optional.of(new ValidationErrors(moduleErrors));
        }
        return Optional.empty();
    }

    private static Optional<Map.Entry<Predicate<KnowledgeDiscoveryRequest>, KDSStatus>> validateCriticalError(KnowledgeDiscoveryRequest kdsRequest) {
        return criticalErrors.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(kdsRequest)).findFirst();
    }

    private static List<ValidationError> validateModule(KnowledgeDiscoveryRequest kdsRequest) {
        ArrayList<ValidationError> moduleErrors = new ArrayList<ValidationError>();
        Module module = kdsRequest.getModuleInfo().getModule();
        if (module != null) {
            KnowledgeDiscoveryRequestValidator.validateUseSpecs(moduleErrors, module);
            KnowledgeDiscoveryRequestValidator.validateQuerySubjects(moduleErrors, module);
        }
        return moduleErrors;
    }

    private static void validateUseSpecs(List<ValidationError> moduleErrors, @Nonnull Module module) {
        List useSpecs = module.getUseSpec();
        if (useSpecs != null && !useSpecs.isEmpty()) {
            for (Module.UseSpec useSpec : useSpecs) {
                KnowledgeDiscoveryRequestValidator.validateUseSpec(moduleErrors, useSpec);
            }
        }
    }

    private static void validateQuerySubjects(List<ValidationError> moduleErrors, @Nonnull Module module) {
        List querySubjects = module.getQuerySubject();
        for (QuerySubject qs : querySubjects) {
            List queryItems = QuerySubjectUtil.getVisibleQueryItems((QuerySubject)qs, (boolean)true);
            for (QueryItem qi : queryItems) {
                KnowledgeDiscoveryRequestValidator.validateQueryItem(moduleErrors, qi);
            }
        }
    }

    private static void validateUseSpec(List<ValidationError> moduleErrors, Module.UseSpec useSpec) {
        useSpecValidationRules.stream().map(function -> (ValidationError)function.apply(useSpec)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> moduleErrors));
    }

    private static void validateQueryItem(List<ValidationError> moduleErrors, QueryItem qi) {
        queryItemValidationRules.stream().map(function -> (ValidationError)function.apply(qi)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> moduleErrors));
    }

    private static void createValidationRules() {
        criticalErrors.put(KnowledgeDiscoveryRequestValidator.isModuleInfoNull(), KDSStatus.REQ_MODULE_INFO_IS_NULL);
        criticalErrors.put(KnowledgeDiscoveryRequestValidator.isResourceUriBlank(), KDSStatus.REQ_RESOURCE_URI_IS_BLANK);
        criticalErrors.put(KnowledgeDiscoveryRequestValidator.isModuleAndModuleUriBothNull(), KDSStatus.REQ_MISSING_REQUIRED_FIELD_IN_MODULE_INFO);
        useSpecValidationRules.add(KnowledgeDiscoveryRequestValidator.isStoreIdBlankInUseSpec());
        queryItemValidationRules.add(KnowledgeDiscoveryRequestValidator.isIdForExpressionInQueryItemBlank());
    }

    private static Predicate<KnowledgeDiscoveryRequest> isModuleInfoNull() {
        return kdsreq -> kdsreq.getModuleInfo() == null;
    }

    private static Predicate<KnowledgeDiscoveryRequest> isResourceUriBlank() {
        return kdsreq -> {
            String resourceUri = kdsreq.getResourceUri();
            if (resourceUri != null) {
                return StringUtils.isBlank((CharSequence)resourceUri);
            }
            return false;
        };
    }

    private static Predicate<KnowledgeDiscoveryRequest> isModuleAndModuleUriBothNull() {
        return kdsreq -> {
            ModuleInfo moduleInfo = kdsreq.getModuleInfo();
            return moduleInfo.getModule() == null && moduleInfo.getModuleUri() == null;
        };
    }

    private static Function<Module.UseSpec, ValidationError> isStoreIdBlankInUseSpec() {
        return useSpec -> {
            KDSStatus status = KDSStatus.REQ_MISSING_STORE_ID;
            return StringUtils.isBlank((CharSequence)useSpec.getStoreID()) ? new ValidationError(status.getStatus(), String.format(status.getMessage(), useSpec.getIdentifier())) : null;
        };
    }

    private static Function<QueryItem, ValidationError> isIdForExpressionInQueryItemBlank() {
        return queryItem -> {
            if (StringUtils.isBlank((CharSequence)queryItem.getIdForExpression())) {
                KDSStatus status = KDSStatus.REQ_MISSING_ID_FOR_EXPRESSION;
                return new ValidationError(status.getStatus(), String.format(status.getMessage(), FIELD_QUERY_ITEM, queryItem.getIdentifier()));
            }
            return null;
        };
    }

    static {
        KnowledgeDiscoveryRequestValidator.createValidationRules();
    }
}

