/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.AbstractClassificationStep;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.Clue;
import com.ibm.smarts.schema.ClueHit;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticAnalysisHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticAnalysisHelper.class);
    private static final float STOPWORD_MATCH = 0.2f;
    public static final String ANY = "any";
    private static final List<String> IGNORABLE_LEMMAS = Arrays.asList("\u00b0");

    private SemanticAnalysisHelper() {
    }

    public static boolean isRequirePruning(Map<String, ClueHit> candidateHits, String colLabel) {
        if (candidateHits.size() == 1 && Float.compare(candidateHits.values().iterator().next().getScore(), 0.5f) > 0 || candidateHits.size() <= 3 && SemanticAnalysisHelper.allSingleClueConcept(candidateHits.values()) || candidateHits.size() > 1 && !SemanticAnalysisHelper.allLowHit(candidateHits.values()) && SemanticAnalysisHelper.allSimilarRelevancy(candidateHits.values())) {
            LOGGER.debug("No pruning required for candidates of [{}]", (Object)colLabel);
            return false;
        }
        return true;
    }

    public static boolean allSimilarRelevancy(Collection<ClueHit> values) {
        ArrayList<ClueHit> hits = new ArrayList<ClueHit>(values);
        boolean isAllRelevant = true;
        for (int i = 0; i < hits.size() - 1; ++i) {
            isAllRelevant = isAllRelevant && SemanticAnalysisHelper.bothRelevant((ClueHit)hits.get(i), (ClueHit)hits.get(i + 1));
        }
        return isAllRelevant;
    }

    public static boolean bothRelevant(ClueHit v1, ClueHit v2) {
        double ratio = Float.compare(v1.getScore(), v2.getScore()) < 0 ? (double)(v1.getScore() / v2.getScore()) : (double)(v2.getScore() / v1.getScore());
        return Double.compare(ratio, 0.55) > 0;
    }

    public static boolean allSingleClueConcept(Collection<ClueHit> values) {
        return values.stream().filter(v -> ((PhraseInfo)CommonJAXBHelper.unmarshalFromJSON(PhraseInfo.class, (String)v.getClue().getTextLexicalInfo())).getTokens().size() > 1).collect(Collectors.toList()).size() == 0;
    }

    public static String serialize(ClueHit hit) {
        return hit.getScore() + " | " + CommonJAXBHelper.marshalToJSON((Object)hit.getClue());
    }

    private static boolean allLowHit(Collection<ClueHit> clueHits) {
        boolean allLowHit = clueHits.stream().allMatch(h -> Float.compare(h.getScore(), 0.001f) < 0);
        if (allLowHit) {
            LOGGER.debug("All low hits so all will be discarded!");
        }
        return allLowHit;
    }

    public static Collection<ClueHit> pruning(Map<String, ClueHit> hits) {
        double delta;
        int pt;
        float alpha = 0.9f;
        if (hits.size() <= 1 || SemanticAnalysisHelper.allLowHit(hits.values())) {
            return Collections.emptyList();
        }
        float mean = hits.values().stream().collect(Collectors.averagingDouble(ClueHit::getScore)).floatValue();
        double sgm = Math.sqrt(hits.values().stream().map(v -> Math.pow(v.getScore() - mean, 2.0)).mapToDouble(Double::doubleValue).sum() / (double)hits.size());
        if (Math.abs(sgm - 0.0) < 1.0E-5) {
            sgm = 1.0E-5;
        }
        double sigma = sgm;
        List<Pair> p = hits.values().stream().map(h -> {
            double z = (double)(h.getScore() - mean) / sigma;
            return new ImmutablePair(h, (Object)z);
        }).collect(Collectors.toList());
        p.sort((p1, p2) -> ((Double)p2.getRight()).compareTo((Double)p1.getRight()));
        if (LOGGER.isDebugEnabled()) {
            p.forEach(c -> LOGGER.debug(((Double)c.getRight()).toString() + "|" + CommonJAXBHelper.marshalToJSON((Object)c.getLeft())));
        }
        for (pt = 1; pt < p.size() && Double.compare(delta = (Double)((Pair)p.get(pt - 1)).getRight() - (Double)((Pair)p.get(pt)).getRight(), 0.9f) <= 0; ++pt) {
        }
        while (pt < p.size() && SemanticAnalysisHelper.shouldKeep((Pair<ClueHit, Double>)((Pair)p.get(pt)))) {
            ++pt;
        }
        LOGGER.debug("Start from {}", (Object)pt);
        return p.subList(0, pt).stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    private static boolean shouldKeep(Pair<ClueHit, Double> pair) {
        return ((PhraseInfo)CommonJAXBHelper.unmarshalFromJSON(PhraseInfo.class, (String)((ClueHit)pair.getLeft()).getClue().getTextLexicalInfo())).getTokens().size() == 1;
    }

    private static void simpleCustomScoring(PhraseInfo phrase, ClueHit clueHit) {
        PhraseInfo clueHitInfo = (PhraseInfo)CommonJAXBHelper.unmarshalFromJSON(PhraseInfo.class, (String)clueHit.getClue().getTextLexicalInfo());
        float f = 0.0f;
        if (phrase.getText().equalsIgnoreCase(clueHit.getClue().getText())) {
            f = 1.3f;
        } else {
            float factor = 1.0f / (float)(phrase.getTokens().size() + clueHitInfo.getTokens().size());
            boolean onlyMatchedStopWord = true;
            double matched = 0.0;
            for (TokenInfo t2 : phrase.getTokens()) {
                double score = clueHitInfo.getTokens().stream().filter(clueHitToken -> t2.getText().equals(clueHitToken.getText()) || t2.getLemma().equals(clueHitToken.getText()) || t2.getLemma().equals(clueHitToken.getLemma())).collect(Collectors.summingDouble(clueHitToken -> SemanticAnalysisHelper.calFactor(clueHitInfo, t2, clueHitToken)));
                if (Double.compare(score, 0.2f) > 0) {
                    onlyMatchedStopWord = false;
                }
                matched += score;
            }
            if (!onlyMatchedStopWord && clueHitInfo.getTokens().stream().anyMatch(t -> t.getText().equals(ANY))) {
                matched += 2.0;
            }
            if (onlyMatchedStopWord) {
                matched *= (double)0.01f;
            }
            f = factor * (float)matched;
        }
        LOGGER.debug("f =  {} for [{}]", (Object)Float.valueOf(f), (Object)clueHit.getClue().getConceptID());
        clueHit.setScore(clueHit.getScore() * f);
    }

    private static double calFactor(PhraseInfo clueHitInfo, TokenInfo t, TokenInfo clueHitToken) {
        if (clueHitToken.getSignificance() < 5 && t.getSignificance() < 5) {
            return 0.2f;
        }
        if (clueHitToken.getSignificance() > 5 && t.getSignificance() > 5) {
            return 2.6f;
        }
        if (t.getSignificance() > 5) {
            return 1.2f + (clueHitToken.getSignificance() < 5 ? 0.6f : 0.8f);
        }
        if (clueHitToken.getSignificance() > 5) {
            return (clueHitInfo.getTokens().size() == 1 ? 1.5f : 1.0f) + (t.getSignificance() < 5 ? 0.3f : 0.6f);
        }
        return 1.3f;
    }

    public static Map<String, List<ClueHit>> collectHits(String lang, PhraseInfo phrase, List<Duration> collectDurations, RequestContext ctx, List<Ontology<OWLOntology>> ontologies) throws Exception {
        Instant before = Instant.now();
        List hits = KnowledgeDiscoveryHelper.getClueManager(ctx).searchClues(phrase.getTokens().stream().map(c -> SemanticAnalysisHelper.toQuery(c)).collect(Collectors.joining(" ")), ctx, new Locale(lang));
        collectDurations.add(Duration.between(before, Instant.now()));
        if (LOGGER.isDebugEnabled()) {
            hits.forEach(h -> LOGGER.debug(h.getClue().getText() + "|" + h.getClue().getConceptID()));
        }
        return hits.stream().filter(h -> AbstractClassificationStep.inDetectedDomains(ontologies, h.getClue().getConceptID())).collect(Collectors.groupingBy(h -> {
            Clue c = h.getClue();
            return c.getConceptID();
        }));
    }

    public static Map<String, List<ClueHit>> collectHits(PhraseInfo phrase, List<Duration> collectDurations, RequestContext ctx, List<Ontology<OWLOntology>> ontologies) {
        try {
            return SemanticAnalysisHelper.collectHits(ctx.locale.getLanguage(), phrase, collectDurations, ctx, ontologies);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getLocalizedMessage());
            return Collections.emptyMap();
        }
    }

    private static String toQuery(TokenInfo c) {
        return c.getText().equalsIgnoreCase(c.getLemma()) || IGNORABLE_LEMMAS.contains(c.getLemma()) ? c.getText() : c.getText() + " " + c.getLemma();
    }

    public static CompletableFuture<Map<String, List<ClueHit>>> collectHitsAsync(String lang, PhraseInfo phrase, RequestContext ctx, List<Ontology<OWLOntology>> ontologies) {
        CompletableFuture hitsF = KnowledgeDiscoveryHelper.getClueManager(ctx).searchCluesAsync(phrase.getTokens().stream().map(c -> SemanticAnalysisHelper.toQuery(c)).collect(Collectors.joining(" ")), ctx, new Locale(lang));
        CompletionStage mapF = hitsF.thenApply(hits -> hits.stream().filter(h -> AbstractClassificationStep.inDetectedDomains(ontologies, h.getClue().getConceptID())).collect(Collectors.groupingBy(h -> {
            Clue c = h.getClue();
            return c.getConceptID();
        })));
        return mapF;
    }

    public static CompletableFuture<Map<String, List<ClueHit>>> collectHitsAsync(PhraseInfo phrase, RequestContext ctx, List<Ontology<OWLOntology>> ontologies) {
        return SemanticAnalysisHelper.collectHitsAsync(ctx.locale.getLanguage(), phrase, ctx, ontologies);
    }

    public static Collection<ClueHit> computeCandidates(PhraseInfo phrase, Map<String, List<ClueHit>> groups) {
        groups.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).filter(h -> h.getClue().getText().contains(ANY)).forEach(h -> h.setScore(h.getScore() * 1.01f));
        groups.entrySet().forEach(e -> ((List)e.getValue()).sort(Comparator.comparing(ClueHit::getScore).reversed()));
        ArrayList<Map.Entry<String, List<ClueHit>>> listGroup = new ArrayList<Map.Entry<String, List<ClueHit>>>(groups.entrySet());
        listGroup.sort((e1, e2) -> Float.compare(((ClueHit)((List)e2.getValue()).get(0)).getScore(), ((ClueHit)((List)e1.getValue()).get(0)).getScore()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CommonJAXBHelper.marshalToJSON((Object)phrase));
            LOGGER.debug("all candidateHits before custom scoring:");
            listGroup.stream().flatMap(e -> ((List)e.getValue()).stream()).map(h -> SemanticAnalysisHelper.serialize(h)).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        LinkedHashMap<String, ClueHit> candidateHits = new LinkedHashMap<String, ClueHit>();
        listGroup.forEach(e -> {
            ClueHit cfr_ignored_0 = (ClueHit)candidateHits.put((String)e.getKey(), (ClueHit)((List)e.getValue()).get(0));
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("eliminated low score hits before custom scoring:");
            candidateHits.values().stream().map(e -> SemanticAnalysisHelper.serialize(e)).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        if (candidateHits.size() >= 1) {
            candidateHits.entrySet().stream().filter(e -> !StringUtils.isBlank((CharSequence)((ClueHit)e.getValue()).getClue().getTextLexicalInfo())).forEach(e -> SemanticAnalysisHelper.simpleCustomScoring(phrase, (ClueHit)e.getValue()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("candidateHits after custom scoring:");
            candidateHits.values().stream().map(e -> SemanticAnalysisHelper.serialize(e)).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        Collection<Object> results = null;
        if (!candidateHits.values().isEmpty()) {
            LOGGER.debug(String.format("candidates for [%s] BEFORE pruning =>", phrase.getText()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(candidateHits.values().stream().map(v -> IRI.create((String)v.getClue().getConceptID().trim()).getShortForm()).collect(Collectors.joining(", ")));
            }
            results = SemanticAnalysisHelper.isRequirePruning(candidateHits, phrase.getText()) ? SemanticAnalysisHelper.pruning(candidateHits) : candidateHits.values();
            LOGGER.debug(String.format("candidates for [%s] AFTER pruning =>", phrase.getText()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(results.stream().map(v -> IRI.create((String)v.getClue().getConceptID().trim()).getShortForm()).collect(Collectors.joining(", ")));
            }
        }
        return results;
    }
}

